<?php
class Enviaya_Shipping_Method extends WC_Shipping_Method
{
    protected $tech_conf_form_fields;
    protected $rating_conf_form_fields;
    protected $access_conf_form_fields;
    protected $adv_conf_form_fields;
    protected $excluded_zones_form_fields;
    protected $sender_addr_form_fields;
    protected $status_form_fields;

    public $parcels;
    public static $instance;

    public function __construct()
    {
        $settings = EYHelper::settings();

        $this->EYTools            = new Enviaya;
        $this->id                 = 'enviaya';
        $this->method_title       = EYHelper::i18n('brand_name');
        $this->title              = EYHelper::i18n('brand_name');
        // $this->enabled            = "yes";
        $this->enabled            = $settings['enable_rating'] == '1' ? "yes" : "not";
        $this->api_key            = $settings['api_key'];
        $this->init();

        self::$instance = $this;

    }

    public static function get()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    function init()
    {
        error_log("INIT: START");

        // Load the settings API
        $this->init_settings();

        // settings form, important for save settings
        $this->access_conf_form_fields    = $this->access_conf_form($this->settings);
        $this->rating_conf_form_fields    = $this->rating_conf_form($this->settings);
        $this->adv_conf_form_fields       = $this->adv_conf_form($this->settings);
        $this->excluded_zones_form_fields = $this->excluded_zones_form($this->settings);
        $this->sender_addr_form_fields    = $this->sender_addr_form($this->settings);
        $this->tech_conf_form_fields      = $this->tech_conf_form($this->settings);
        $this->status_form_fields         = $this->status_form($this->settings);

        $this->form_fields = array_merge(
            $this->access_conf_form_fields,
            $this->rating_conf_form_fields,
            $this->adv_conf_form_fields,
            $this->excluded_zones_form_fields,
            $this->sender_addr_form_fields,
            $this->tech_conf_form_fields,
            $this->status_form_fields
        );

        // Save settings in admin if you have any defined
        add_action('woocommerce_update_options_shipping_' . $this->id, [$this, 'process_admin_options']);

        // JS and CSS
        add_action('admin_enqueue_scripts', [$this, 'js']);
        add_action('admin_enqueue_scripts', [$this, 'css']);

        // self::setCustomTitleRating();

        error_log("INIT: FINISH");
    }

    public static function getTitleRatingConfiguration()
    {
        $settings = EyHelper::settings();

        return $settings['title_rating_configuration'];
    }//end

    public static function getProductPrice($product_id)
    {
        global $wpdb;

        $states = $wpdb->get_results("SELECT meta_value FROM {$wpdb->prefix}postmeta
            WHERE post_id = {$product_id} AND meta_key = '_price'");

        return $states[0]->meta_value;
    }

    public static function if_cart_shipping_enabled()
    {
        $settings = EYHelper::settings();

        error_log("IF_CART_SHIPPING_ENABLED: START");

        return $settings['enable_estimated_shipping'];
    }

    public static function get_timeout()
    {
        $settings = EYHelper::settings();

        error_log("GET_TIMEOUT: START222");

        return $settings['timeout'];
    }

    public static function shipping_service_design()
    {
        $settings = EYHelper::settings();

        error_log("SHIPPING_SERVICE_DESIGN: START");

        $result['show_carrier_logo']       = $settings['display_carrier_logo'];
        $result['group_by_carrier']        = $settings['group_by_carrier'];
        $result['shipping_service_design'] = $settings['shipping_service_design'];

        return $result;
    }

    private function is_excluded_zone($package)
    {
        $settings = EYHelper::settings();

        $curZone = $package["destination"];
        if (!array_key_exists('excluded_zones_data', $settings)) {
            return false;
        } else if (empty(json_decode($settings['excluded_zones_data']))) {
            return false;
        }
        foreach (json_decode($settings['excluded_zones_data']) as $zone) {
            $subZone = explode(',', $zone->regions);
            $country = isset($subZone[0]) && explode(':', $subZone[0])[0] === 'country' ?
                explode(':', $subZone[0])[1] : false;
            $state = isset($subZone[1]) && explode(':', $subZone[1])[0] === 'state' ?
                explode(':', $subZone[1])[2] : false;
            $zip = explode(',', $zone->zips);

            if (
                (!$state && $country && $curZone['country'] === $country) ||
                ($state && $country && $curZone['country'] === $country && $curZone['state'] === $state) ||
                (!empty($zip) && in_array($curZone['postcode'], $zip))
            ) {
                return true;
            }
        }

        return false;
    }

    /*===[INIT methods for design advance]===*/
    public function getStructRate() {
        return "<span class=enviaya_carrier_name>[!shipping_carrier_name!]</span>
                <span class=enviaya_service>[!carrier_service_name!]</span> [!delimiter!]
                <span class=enviaya_delivery_date>[!delivery_date!]</span>
                <span class=enviaya_amount>([!price!][!currency!])</span>";
    }//end

    public function setCarrierName($setting_carrier_name, $struct_rate, $carrier_name)
    {
        //show carrier name
        if($setting_carrier_name == '1')
        {
            return str_replace("[!shipping_carrier_name!]", $carrier_name, $struct_rate);
        }

        return str_replace("[!shipping_carrier_name!]", "", $struct_rate);
    }//end

    public function setServiceName($setting_design_advance, $struct_rate, $service_name)
    {
        if($setting_design_advance == '0'){
            return str_replace("[!carrier_service_name!]", $service_name->dynamic_service_name, $struct_rate);
        }

        if($setting_design_advance == '1'){
            $name = ($service_name->enviaya_service_name)? $service_name->enviaya_service_name : $carrier_rate->carrier_service_name ;
            return str_replace("[!carrier_service_name!]", $name, $struct_rate);
        }

        if($setting_design_advance == '2'){
            return str_replace("[!carrier_service_name!]", $service_name->carrier_service_name, $struct_rate);
        }

        if($setting_design_advance == 'custom'){
            return str_replace("[!carrier_service_name!]", $service_name, $struct_rate);
        }

        return str_replace("[!carrier_service_name!]", "", $struct_rate);
    }//end

    public function setDeliveryDate($setting_delivery_date, $struct_rate, $delivery_date)
    {
        if($setting_delivery_date == 0)
        {
            return str_replace("[!delivery_date!]", date_format(date_create($delivery_date->estimated_delivery), "d/m/Y"), $struct_rate);
        }

        if($setting_delivery_date == 1)
        {
            return str_replace( "[!delivery_date!]",
                                self::calc_delivery_time((float)str_replace('-','',$delivery_date->est_transit_time_hours)), $struct_rate);
        }

        return str_replace("[!delivery_date!]", "", $struct_rate);
    }//end

    public function setAmountAndCurrency($setting_advance_free, $struct_rate, $carrier_rate)
    {
        //Set empty carrier name
        $struct_rate = str_replace("[!shipping_carrier_name!]", "", $struct_rate);

        //Set empty delivery date
        $struct_rate = str_replace("[!delivery_date!]", "", $struct_rate);

        //Set empty delimiter
        $struct_rate = str_replace("[!delimiter!]", "", $struct_rate);

        if($setting_advance_free == '0')
        {
            $struct_rate = str_replace("([!price!][!currency!])", "", $struct_rate);
        }

        return $this->setServiceName("custom", $struct_rate, $carrier_rate->additional_configuration->free_shipping->free_shipping_name);
    }//end

    public function setDefaultOrAdvancedDesign($setting_design_advance, $struct_rate, $logo, $setting_show_logo, $setting_service_design)
    {
        //With logo
        if($setting_design_advance == '1')
        {
            $struct_rate = ($setting_show_logo == '1' ? $logo : "").$struct_rate;
            return $this->setShowShippingService($setting_service_design, $struct_rate );
        }

        return $this->setShowShippingService(0, $struct_rate );
    }//end

    public function setShowShippingService($setting_show_service, $struct_rate)
    {
        if($setting_show_service == 1)
        {
            return str_replace("[!delimiter!]", "<br>", $struct_rate);
        }

        return str_replace("[!delimiter!]", "", $struct_rate);
    }

    // Override calculated shipping
    public function calculate_shipping($package = array())
    {
        $settings = EYHelper::settings();

        if (!$this->is_excluded_zone($package)) {
            if (isset($package['rates'])) {
                foreach ($package['rates'] as $key => $value) {
                    unset($package['rates'][$key]);
                }
            }

            error_log("CALCULATE_SHIPPING: START" . json_encode($package));

            $dest_country   = $package["destination"]["country"];
            $dest_postcode  = $package["destination"]['postcode'];
            $dest_statecode = $package["destination"]['state'];

            if (isset($this->settings['origin_address']) && ($this->settings['origin_address'] != 'none')) {
                $origins = str_replace('||', '"', $this->settings['origin_address']);
                $origin = json_decode($origins);

                $country = get_option('woocommerce_default_country');
                $arr = explode(":", $country);
                $country = $arr[0];

                $origin_country   = isset($origin->country_code) ? $origin->country_code: $country;
                $origin_postcode  = isset($origin->postal_code) ? $origin->postal_code  : null;
                $origin_statecode = isset($origin->state_code) ? $origin->state_code    : null;
            } else {
                return false;
            }

            $total = WC()->cart->subtotal;
            $order_total_amount = $settings['enable_currency_support'] === 'yes' ?
                apply_filters('raw_woocommerce_price', floatval($total < 0 ? $total * -1 : $total)) : $total;

            $parcels = $this->calculate_parcels($package);

            $props = [
                'parcels'                   => $parcels,
                'origin_country_code'       => $origin_country,
                'origin_postal_code'        => $origin_postcode,
                'origin_state_code'         => $origin_statecode,
                'destination_country_code'  => $dest_country,
                'destination_postal_code'   => $dest_postcode,
                'destination_state_code'    => $dest_statecode,
                'order_total_amount'        => (float)$order_total_amount,
            ];

            //dokan use
            $user_id = isset($package['seller_id']) ? $package['seller_id'] : null;
            $dokan_enviaya_use = get_user_meta($user_id, 'dokan_enviaya_use', true);

            if (($settings['doken_integration'] === "yes") && ((int)$dokan_enviaya_use === 1) && !is_super_admin($user_id))
            {
                $dokan = [
                    'api_key' => (int)get_user_meta($user_id, 'dokan_enviaya_enabled_test_mode', true) === 1 ? get_user_meta($user_id, 'dokan_enviaya_api_key_test', true) : get_user_meta($user_id, 'dokan_enviaya_api_key_production', true),
                    'account' => get_user_meta($user_id, 'dokan_enviaya_account', true),
                    'timeout' => get_user_meta($user_id, 'dokan_enviaya_timeout', true)
                ];

                $origin = json_decode(base64_decode(get_user_meta($user_id, 'dokan_sender_address', true)));
                $country = get_option('woocommerce_default_country');
                $arr = explode(":", $country);
                $country = $arr[0];
                $origin_country = isset($origin->country_code) ? $origin->country_code : $country;
                $origin_postcode = isset($origin->postal_code) ? $origin->postal_code : null;
                $origin_statecode = isset($origin->state_code) ? $origin->state_code : null;

                $props = [
                    'parcels'                   => $parcels,
                    'origin_country_code'       => $origin_country,
                    'origin_postal_code'        => $origin_postcode,
                    'origin_state_code'         => $origin_statecode,
                    'destination_country_code'  => $dest_country,
                    'destination_postal_code'   => $dest_postcode,
                    'destination_state_code'    => $dest_statecode,
                    'order_total_amount'        => (float)$order_total_amount,
                ];

                $result = EYHelper::libAPIdokan($dokan)->calculate(EYHelper::create($props));
            }
            else
            {
                $result = EYHelper::libAPI()->calculate(EYHelper::create($props));
            }

            $product = array();

            foreach ($package['contents'] as $item_id => $values)
            {
                for ($i = 1; $i <= $values['quantity']; $i++)
                {
                    $product[] = $values;
                }
            }


            if ((int)$settings['enable_rating'] === 1)
            {
                $response = $result['response'];
            }
            else
            {
                $response = null;
            }

            error_log("CALCULATE_SHIPPING REQUEST:" . json_encode($result['request']));
            logAPI(json_encode($result['request']), 'rating_request');

            error_log("CALCULATE_SHIPPING RESPONSE:" . json_encode($response));
            logAPI(json_encode($response), 'rating_response');

            $tax = get_option('woocommerce_calc_taxes');

            $rate_list = array();

            if (!empty($response) && empty($response->errors)) {


                foreach ($response as $key => $carrier) {
                    if ($key === 'store_pickup') {
                        $rate = array(
                            'label' => $carrier->dynamic_service_name,
                            'cost' => 0,
                            'user' => isset($package['user']) && isset($package['user']->id) ?
                                $package['user']->id : null,
                            'meta_data' => array(
                                'label_advanced' => $carrier->dynamic_service_name,
                                'rate_id' => 0,
                                'carrier_name' => $carrier->carrier,
                                'carrier_service_name' => $carrier->carrier_service_name,
                                'carrier_service_code' => $carrier->carrier_service_code,
                                'carrier_logo' => $carrier->carrier_logo_url,
                                'estimated_delivery' => $carrier->estimated_delivery,
                                'delivery_cost' => 0,
                            )
                        );

                        array_unshift($rate_list, $rate);
                    }

                    //normal loop for shipping
                    if (!empty($carrier) && $key !== "warning" && $key !== "store_pickup") {
                        foreach ($carrier as $carrier_rate) {
                            if (isset($carrier_rate->rate_id)) {
                                if (isset($carrier_rate->messages) && $carrier_rate->messages === null) {
                                    continue;
                                }

                                $_price = $tax == 'yes' ? $carrier_rate->net_total_amount : $carrier_rate->total_amount;

                                $estimated_delivery = isset($carrier_rate->estimated_delivery) ?
                                                        date_create($carrier_rate->estimated_delivery) : null;

                                                        $logo = "<img class=enviaya_carrier_logo src='{$carrier_rate->carrier_logo_url}'>";
                                $struct_rate = $this->getStructRate();

                                if(isset($carrier_rate->additional_configuration))
                                {
                                    $_price       = '0.00';
                                    $struct_rate = $this->setAmountAndCurrency($settings['as_defined_price'], $struct_rate, $carrier_rate);
                                }
                                else
                                {
                                    $struct_rate = $this->setCarrierName($settings['shipping_carrier_name'], $struct_rate, $carrier_rate->carrier);

                                    $struct_rate = $this->setDeliveryDate($settings['shipping_delivery_time'], $struct_rate, $carrier_rate);
                                    $struct_rate = $this->setServiceName($settings['shipping_service_design_advanced'], $struct_rate, $carrier_rate);
                                    $struct_rate = $this->setDefaultOrAdvancedDesign($settings['default_or_advanced_design'], $struct_rate, $logo,
                                                                                $settings['display_carrier_logo'], $settings['shipping_service_design'] );
                                }//end

                                $rate = array(
                                    'id'        => $carrier_rate->rate_id,
                                    'label'     => $struct_rate,
                                    'cost'      => $_price,
                                    'net_total_amount' => $carrier_rate->net_total_amount,
                                    'total_amount' => $carrier_rate->total_amount,
                                    'user'      => isset($package['user']) && isset($package['user']->id) ? $package['user']->id : null,
                                    'meta_data' => array(
                                        'label_advanced'       => $struct_rate,
                                        'rate_id'              => $carrier_rate->rate_id,
                                        'carrier_name'         => $carrier_rate->carrier,
                                        'carrier_service_name' => $carrier_rate->carrier_service_name,
                                        'carrier_service_code' => $carrier_rate->carrier_service_code,
                                        'carrier_logo'         => $carrier_rate->carrier_logo_url,
                                        'estimated_delivery'   => isset($carrier_rate->estimated_delivery) ? $carrier_rate->estimated_delivery : null,
                                        'delivery_cost'        => $_price,
                                    )
                                );

                                $rate_list[] = $rate;
                            }
                        }
                    }

                    /* Improove this section code */
                    if($key === "warning" && current_user_can( 'manage_woocommerce' )){
                        $warningMsj = "";
                        if(sizeof($carrier)){
                            foreach(json_decode(json_encode($carrier), true) as $msjw){
                                $warningMsj .= '<p>'.(string)$msjw.'</p>';
                            }//end

                            add_filter( 'woocommerce_cart_totals_before_shipping', function() use ($warningMsj) {
                                echo '<div class="enviaya-info err">'.$warningMsj.'</div>';
                            });

                            add_filter( 'woocommerce_review_order_before_shipping', function() use ($warningMsj) {
                                echo '<div class="enviaya-info err">'.$warningMsj.'</div>';
                            });
                        }//end
                    }//end
                }
            } else {


                if ($this->settings['enable_contingency_shipping'] == '1') {
                    if ($settings['enable_rating'] == '1') {
                        if (is_plugin_active('enviaya-for-woocommerce/enviaya-for-woocommerce.php')) {

                            $woocommerce_prices_include_tax = get_option('woocommerce_prices_include_tax');

                            if ($this->settings['enable_standard_flat_rate'] == 'yes') {

                              if($woocommerce_prices_include_tax == 'yes'){

                                $shippint_net_total_amount = number_format($this->settings['standard_flat_rate']/1.16,2,'.','.');
                                $shipping_total_amount =  $this->settings['standard_flat_rate'];


                              }else{

                                $shippint_net_total_amount = $this->settings['standard_flat_rate'];
                                $shipping_total_amount =  number_format($this->settings['standard_flat_rate']*1.16,2,'.','') ;


                              }

                              $_price = $tax == 'yes' ? $shippint_net_total_amount : $shipping_total_amount;

                              $label = ( isset($this->settings['standard_flat_rate_title']) && !empty($this->settings['standard_flat_rate_title']) )  ? $this->settings['standard_flat_rate_title'] : EYHelper::i18n('contingency_standard_shipping_default');

                              $rate = array(
                                    'id'                       => 'standard_flat_rate',
                                    'label'                    => $label.' ([!price!][!currency!])',
                                    'cost'                     => $_price,
                                    'net_total_amount'         => $shippint_net_total_amount,
                                    'total_amount'             => $shipping_total_amount,
                                    'meta_data'                => array(
                                        'label_advanced'       => $label.' ([!price!][!currency!])',
                                        'rate_id'              => '0',
                                        'carrier_name'         => 'Standard Flat Rate',
                                        'carrier_service_name' => 'Standard Flat Rate',
                                        'carrier_logo'         => '',
                                        'estimated_delivery'   => '',
                                        //'delivery_cost'        => 1002,
                                    ),
                                );
                                $this->add_rate();
                                $rate_list[] = $rate;
                            }
                            if ($this->settings['enable_express_flat_rate'] == 'yes') {

                                if($woocommerce_prices_include_tax == 'yes'){

                                  $shippint_net_total_amount = number_format($this->settings['express_flat_rate']/1.16,2,'.','');
                                  $shipping_total_amount =  $this->settings['express_flat_rate'];

                                }else{

                                  $shippint_net_total_amount = $this->settings['express_flat_rate'];
                                  $shipping_total_amount =  number_format($this->settings['express_flat_rate']*1.16,2,'.','') ;

                                }

                                $_price = $tax == 'yes' ? $shippint_net_total_amount : $shipping_total_amount;

                                $label = ( isset($this->settings['express_flat_rate_title']) && !empty($this->settings['express_flat_rate_title']) )  ? $this->settings['express_flat_rate_title'] : EYHelper::i18n('contingency_express_shipping_default');

                                $rate = array(
                                    'id' => 'express_flat_rate',
                                    'label' => $label.' ([!price!][!currency!])',
                                    'cost' => $_price,
                                    'net_total_amount' => $shippint_net_total_amount,
                                    'total_amount' => $shipping_total_amount,
                                    'meta_data' => array(
                                        'label_advanced' =>$label.' ([!price!][!currency!])',
                                        'rate_id' => '1',
                                        'carrier_name' => 'Express Flat Rate',
                                        'carrier_service_name' => 'Express Flat Rate',
                                        'carrier_logo' => '',
                                        'estimated_delivery' => '',
                                        //'delivery_cost' => $_price,
                                    ),
                                );
                                $this->add_rate();
                                $rate_list[] = $rate;
                            }
                        } else {
                            $this->add_rate(array(
                                'id' => 'standard_flat_rate',
                                'label' => $this->settings['standard_flat_rate_title'],
                                'cost' => $this->settings['standard_flat_rate'],
                                'net_total_amount' => $shippint_net_total_amount,
                                'total_amount' => $shipping_total_amount,
                                'meta_data' => array(
                                    'label_advanced' => $label.' ([!price!][!currency!])',
                                    'rate_id' => '0',
                                    'carrier_name' => 'Standard Flat Rate',
                                    'carrier_service_name' => 'Standard Flat Rate',
                                    'carrier_logo' => '',
                                    'estimated_delivery' => '',
                                    'delivery_cost' => $this->settings['standard_flat_rate'],
                                ),
                            ));
                            $this->add_rate(array(
                                'id' => 'express_flat_rate',
                                'label' => $this->settings['express_flat_rate_title'],
                                'cost' => $this->settings['express_flat_rate'],
                                'meta_data' => array(
                                    'label_advanced' => $label.' ([!price!][!currency!])',
                                    'rate_id' => '1',
                                    'carrier_name' => 'Express Flat Rate',
                                    'carrier_service_name' => 'Express Flat Rate',
                                    'carrier_logo' => '',
                                    'estimated_delivery' => '',
                                    'delivery_cost' => $this->settings['express_flat_rate'],
                                ),
                            ));
                        }
                    }
                }
            }

            /* Message Zone */
            $hasPermissions = false;

            if (current_user_can('manage_woocommerce')) {
                $hasPermissions = true;
            }

            if (
                $hasPermissions && !empty($response) && !empty($response->errors)
                && !empty(array_column((array)$response, 'parcels'))
            ) {

                add_filter('woocommerce_cart_totals_before_shipping', function () {
                    echo '<div class="enviaya-info err">' . EYHelper::i18n('no_dimensions_error') . '</div>';
                });

                add_filter('woocommerce_review_order_before_shipping', function () {
                    echo '<div class="enviaya-info err">' . EYHelper::i18n('no_dimensions_error') . '</div>';
                });
            } elseif (
                $hasPermissions && !empty($response) &&
                !empty($response->errors) && !empty($response->errors->parcels)
            ) {
                /* not working because is same condition that 617 line */
                add_filter('woocommerce_cart_totals_before_shipping', function () {
                    echo '<div class="enviaya-info err">' . EYHelper::i18n('no_weight_error') . '</div>';
                });

                add_filter('woocommerce_review_order_before_shipping', function () {
                    echo '<div class="enviaya-info err">' . EYHelper::i18n('no_weight_error') . '</div>';
                });
            }

            usort($rate_list, function ($a, $b) {
                return $a['cost'] > $b['cost'];
            });
            $currency = $settings['enable_currency_support'] !== 'yes' && $settings['default_currency'] ? $settings['default_currency'] : get_woocommerce_currency();

            foreach ($rate_list as $rate) {
                $cost = $settings['enable_currency_support'] === 'yes' ? $rate['cost'] :
                        apply_filters('raw_woocommerce_price', floatval($rate['cost'] < 0 ? $rate['cost'] * -1 : $rate['cost']));

                if($tax == 'yes'){
                  $cost =  get_option('woocommerce_tax_display_cart') == 'incl' ? $rate['total_amount'] : $rate['net_total_amount'];
                }

                //Free shipping, number format
                $cost = ($cost == 0)? number_format($cost, 2,".", ",") : $cost;

                $rate['label'] = str_replace(
                    ['[!currency!]', '[!price!]', '[!carrier_service_name!]'],
                    [$currency, $cost, $rate['meta_data']['carrier_service_name']],
                    $rate['label']
                );


                $rate['meta_data']['label_advanced'] = str_replace(
                    '[!currency!]',
                    $currency,
                    $rate['meta_data']['label_advanced']
                );
                $rate['meta_data']['label_advanced'] = base64_encode(str_replace(
                    ['[!price!]', '[!currency!]'],
                    [$cost, $currency],
                    $rate['meta_data']['label_advanced']
                ));


                $this->add_rate($rate);
            }
        }
    }

    public function calc_delivery_time($item)
    {
        if ($item < 24) {
            $result = round($item, 1);

            if ($result == 1) {
                $result = $result . ' ' . EYHelper::i18n('hour');
            } else {
                $result = $result . ' ' . EYHelper::i18n('hours');
            }
        } else {
            $result = round($item / 24, 1);

            if ($result == 1) {
                $result = $result . ' ' . EYHelper::i18n('day');
            } else {
                $result = $result . ' ' . EYHelper::i18n('days');
            }
        }

        return $result;
    }

    public function calculate_parcels($package = array())
    {
        $_parcels = array();

        foreach ($package['contents'] as $item_id => $values) {
            $_Q = $values['quantity'];
            $_qty = (float)$_Q;
            $endWeight = 0;
            $weightUnit = 'kg';
            $tmpLength = null;
            $tmpHeight = null;
            $tmpWidth = null;
            $dimensionUnit = null;

            if (!empty($values['data'])) {
                $product = $values['data'];
                //error_log('Product type: ' . json_encode(gettype($product)));

                $thisParcel = null;
                $_weight = (float)$product->get_weight();

                $tmpLength = $product->get_length() ? (float)$product->get_length() : null;
                $tmpHeight = $product->get_height() ? (float)$product->get_height() : null;
                $tmpWidth = $product->get_width() ? (float)$product->get_width() : null;

                $weightUnit = get_option('woocommerce_weight_unit');
                $dimensionUnit = get_option('woocommerce_dimension_unit');

                if ($_weight && $weightUnit === 'g') {
                    $_weight /= 1000;
                    $weightUnit = 'kg';
                }

                if ($_weight && $weightUnit === 'oz') {
                    $_weight /= 35.274;
                    $weightUnit = 'kg';
                }

                $endWeight = round($_weight, 2);
            }

            $thisParcel = array(
                'quantity'      => $_qty,
                'weight'        => $endWeight ? round($endWeight, 2) : null,
                'weight_unit'   => $weightUnit,
                'length'        => $tmpLength ? round($tmpLength, 2) : null,
                'height'        => $tmpHeight ? round($tmpHeight, 2) : null,
                'width'         => $tmpWidth ? round($tmpWidth, 2) : null,
                'dimension_unit' => $dimensionUnit,
            );

            $_parcels[] = $thisParcel;
        }

        return $_parcels;
    }

    public function js()
    {
        $lang = EYHelper::i18n(null);

        $language = strpos(get_user_locale(), "_");
        $languageKey = substr(get_user_locale(), 0, $language);

        echo "<script>
                function lang() {
                    return " . json_encode($lang) . ";
                }
                function locale() {
                    return '" . $languageKey . "';
                }
                </script>";

        wp_register_script(
            'ey-admin-ajax',
            plugins_url('admin/js/ajax.js', ENVIAYA_FILE),
            array('jquery'),
            '1.13',
            $in_footer = true
        );
        wp_enqueue_script('ey-admin-ajax');
    }

    public function css()
    {
        // error_log("CSS: START");

        wp_enqueue_style('ey-admin-css', plugins_url('admin/css/enviaya.css', ENVIAYA_FILE));
    }

    // Override admin options
    public function admin_options()
    {
        global $woocommerce;

        $settings = EYHelper::settings();

        $php_version    = PHP_VERSION;
        $wp_version     = get_bloginfo('version');
        $wc_version     = $woocommerce->version;
        $server_name    = $_SERVER['SERVER_NAME'];
        $curl_exists    = class_exists('WP_Http_Curl') ? 'Yes' : 'No';
        $stringSupport  = base64_encode(json_encode([
            'php_version'           => $php_version,
            'wordpress_version'     => $wp_version,
            'woocommerce_version'   => $wc_version,
            'server_name'           => $server_name,
            'curl_exists'           => $curl_exists
        ]));
    ?>
        <?php $this->js(); ?>

        <!-- manage tags -->
        <h2 class="nav-tab-wrapper" id="enviaya_admin">
            <a href="#" class="nav-tab tablinks" onclick="openTab(event, 'enviaya-access-conf'); return false;" id="defaultOpen"><?= EYHelper::i18n('access_configuration'); ?></a>
            <a href="#" class="nav-tab tablinks" onclick="openTab(event, 'enviaya-rating-conf'); return false;">
                <?= EYHelper::i18n('rating_configuration'); ?></a>
            <a href="#" class="nav-tab tablinks" onclick="openTab(event, 'enviaya-adv-conf'); return false;">
                <?= EYHelper::i18n('advanced_configuration'); ?></a>
            <a href="#" class="nav-tab tablinks" onclick="openTab(event, 'enviaya-excluded-zones'); return false;">
                <?= EYHelper::i18n('excluded_zones'); ?></a>
            <a href="#" class="nav-tab tablinks" onclick="openTab(event, 'enviaya-sender-addr'); return false;">
                <?= EYHelper::i18n('sender_address'); ?></a>
            <a href="#" class="nav-tab tablinks" onclick="openTab(event, 'enviaya-technical-conf'); return false;">
                <?= EYHelper::i18n('technical_configuration'); ?></a>
            <a href="#" class="nav-tab tablinks" onclick="openTab(event, 'enviaya-status'); return false;">
                <?= EYHelper::i18n('status'); ?></a>
        </h2>

        <!-- manage modal -->
        <?php add_thickbox(); ?>
        <a href="#TB_inline?width=600&height=550&inlineId=modal-window-id" style="display: none;" id="thickbox" class="thickbox">click here</a>
        <div id="modal-window-id" style="display: none;">
            <div id="slide1">
                <h2><?= EYHelper::getReplacingKeyi18n('{#brand_name#}', 'brand_name', 'welcome_screen_1_title'); ?></h2>
                <p><?= EYHelper::getReplacingKeyi18n('{#api_link#}', 'api_domain', 'welcome_screen_1_text'); ?></p>
                <table class="form-table">
                    <tbody>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="woocommerce_enviaya_api_key_production">
                                    <?= EYHelper::i18n('api_key'); ?>
                                </label>
                            </th>
                            <td class="forminp">
                                <fieldset>
                                    <legend class="screen-reader-text">
                                        <span><?= EYHelper::i18n('api_key'); ?></span>
                                    </legend>
                                    <input class="input-text regular-input" id="instruction_api" type="text" style="width: 400px;" value="">
                                </fieldset>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="woocommerce_enviaya_api_key_production">
                                    <?= EYHelper::i18n('test_api_key'); ?>
                                </label>
                            </th>
                            <td class="forminp">
                                <fieldset>
                                    <legend class="screen-reader-text">
                                        <span><?= EYHelper::i18n('test_api_key'); ?></span>
                                    </legend>
                                    <input class="input-text regular-input" id="instruction_test_api" type="text" style="width: 400px;" value="">
                                </fieldset>
                            </td>
                        </tr>
                    </tbody>
                </table>

            </div>
            <div id="slide2" style="display: none;">
                <h2><?= EYHelper::i18n('welcome_screen_2_title'); ?></h2>
                <p><?= EYHelper::i18n('welcome_screen_2_text'); ?></p>
                <table class="form-table">
                    <tbody>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="instruction_billing_account">
                                    <?= EYHelper::i18n('account'); ?>
                                </label>
                            </th>
                            <td class="forminp">
                                <fieldset>
                                    <legend class="screen-reader-text">
                                        <span><?= EYHelper::i18n('account'); ?></span>
                                    </legend>
                                    <select class="select wc-enhanced-select" id="instruction_billing_account" style="min-width:300px;" tabindex="-1" aria-hidden="true">
                                    </select>
                                </fieldset>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div id="slide3" style="display: none;">
                <h2><?= EYHelper::i18n('welcome_screen_3_title'); ?></h2>
                <p><?= EYHelper::i18n('welcome_screen_3_text'); ?></p>
                <table class="form-table">
                    <tbody>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="woocommerce_enviaya_origin_address">
                                    <?= EYHelper::i18n('sender_address'); ?>
                                </label>
                            </th>
                            <td class="forminp">
                                <fieldset>
                                    <legend class="screen-reader-text">
                                        <span><?= EYHelper::i18n('sender_address'); ?></span>
                                    </legend>
                                    <select class="select wc-enhanced-select" id="instruction_origin_address" style="min-width:300px;" tabindex="-1" aria-hidden="true">
                                    </select>
                                    <p class="description" id="select2_error" style="display: none">
                                        <?= EYHelper::i18n('api_key_error'); ?>
                                    </p>
                                </fieldset>
                            </td>
                        </tr>
                    </tbody>
                </table>

            </div>
            <div id="slide4" style="display: none;">
                <h2><?= EYHelper::i18n('welcome_screen_4_title'); ?></h2>
                <p>
                    <?= EYHelper::getReplacingKeyi18n('{#api_link#}', 'api_domain', 'welcome_screen_4_text'); ?>
                </p>

            </div>
            <div id="slide5" style="display: none;">
                <h2><?= EYHelper::i18n('welcome_screen_5_title'); ?></h2>
                <p><?= EYHelper::i18n('welcome_screen_5_text'); ?></p>

            </div>

            <button type="button" class="button-primary w_countinue">
                <?= EYHelper::i18n('countinue'); ?>
            </button>
        </div>
        <!-- end manage modal -->

        <!-- content tag access-conf -->
        <div class="tabcontent enviaya-settings" id="enviaya-access-conf">
            <?php
            $this->form_fields = $this->access_conf_form($this->settings);
            parent::admin_options();
            ?>
        </div>
        <!-- end content -->

        <!-- content tag raiting-conf -->
        <div class="tabcontent  enviaya-settings" id="enviaya-rating-conf">
            <?php
            $this->form_fields = $this->rating_conf_form($this->settings);
            parent::admin_options();
            ?>
        </div>
        <!-- end content raiting -->

        <!-- content tag adv-conf -->
        <div class="tabcontent  enviaya-settings" id="enviaya-adv-conf">
            <?php
            $this->form_fields = $this->adv_conf_form($this->settings);
            parent::admin_options();
            ?>
        </div>
        <!-- end content -->

        <!-- content tag excluded-zones-->
        <div class="tabcontent  enviaya-settings" id="enviaya-excluded-zones">
            <?php
            global $wpdb;

            $this->form_fields = $this->excluded_zones_form_title($this->settings);
            parent::admin_options();

            $locations = $wpdb->get_results("SELECT * FROM `{$wpdb->prefix}woocommerce_tax_rate_locations`");
            $continents = WC()->countries->get_continents();
            $allowed_countries = WC()->countries->get_allowed_countries();
            ?>
            <table class="form-table">
                <tbody>
                    <tr valign="top" class="">
                        <th scope="row" class="titledesc">
                            <label for="zone_name">
                                <?php esc_html_e(EYHelper::i18n('zone_name')); ?>
                                <?php echo wc_help_tip(EYHelper::i18n('zone_name_help')); ?>
                            </label>
                        </th>
                        <td class="forminp">
                            <input type="text" data-attribute="zone_name" name="zone_name" id="excluded_zone_name" value="" placeholder="<?php esc_attr_e(EYHelper::i18n('zone_name')); ?>">
                        </td>
                    </tr>
                    <tr valign="top" class="">
                        <th scope="row" class="titledesc">
                            <label for="zone_locations">
                                <?php esc_html_e(EYHelper::i18n('zone_regions')) ?>
                                <?php echo wc_help_tip(EYHelper::i18n('zone_regions_help')); // @codingStandardsIgnoreLine
                                ?>
                            </label>
                        </th>
                        <td class="forminp">
                            <select multiple="multiple" data-attribute="zone_locations" id="excluded_zone_locations" name="zone_locations" data-placeholder="<?php esc_html_e(EYHelper::i18n('zone_regions_placeholder')); ?>" class="wc-shipping-zone-region-select chosen_select">
                                <?php
                                foreach ($continents as $continent_code => $continent) {
                                    echo '<option value="continent:' . esc_attr($continent_code) . '"' . (in_array("continent:$continent_code", $locations) ? ' selected="true"' : '') . ' alt="">' . esc_html($continent['name']) . '</option>';

                                    $countries = array_intersect(array_keys($allowed_countries), $continent['countries']);

                                    foreach ($countries as $country_code) {
                                        echo '<option value="country:' . esc_attr($country_code) . '"' . (in_array("country:$country_code", $locations) ? ' selected="true"' : '') . ' alt="' . esc_attr($continent['name']) . '">' . esc_html('&nbsp;&nbsp; ' . $allowed_countries[$country_code]) . '</option>';

                                        if ($states = WC()->countries->get_states($country_code)) {
                                            foreach ($states as $state_code => $state_name) {
                                                echo '<option value="state:' . esc_attr($country_code . ':' . $state_code) . '"' . (in_array("state:$country_code:$state_code", $locations) ? ' selected="true"' : '') . ' alt="' . esc_attr($continent['name'] . ' ' . $allowed_countries[$country_code]) . '">' . esc_html('&nbsp;&nbsp;&nbsp;&nbsp; ' . $state_name) . '</option>';
                                            }
                                        }
                                    }
                                }
                                ?>
                            </select>
                            <div>
                                <textarea name="zone_postcodes" data-attribute="zone_postcodes" id="excluded_zone_postcodes" placeholder="<?php esc_attr_e(EYHelper::i18n('zone_regions_list_placeholder')); ?>" class="input-text large-text" cols="25" rows="5"></textarea>
                                <span class="description">
                                    <?php printf(EYHelper::i18n('zone_regions_list_help'), 'https://docs.woocommerce.com/document/setting-up-shipping-zones/#section-3'); ?>
                                </span><?php // @codingStandardsIgnoreLine.
                                        ?>
                            </div><br />

                            <button class="button-primary add-zone-btn"><?php echo EYHelper::i18n('add_zone'); ?></button>
                        </td>
                    </tr>
                    <tr valign="top" class="">
                        <th scope="row" class="titledesc">
                            <label for="all_zones">
                                <?php esc_html_e(EYHelper::i18n('excluded_zones')); ?>
                            </label>
                        </th>
                        <td class="forminp">
                            <table class="wc-shipping-zone-methods widefat">
                                <thead>
                                    <tr>
                                        <th><?php echo EYHelper::i18n('excluded_zones_table_name'); ?></th>
                                        <th><?php echo EYHelper::i18n('excluded_zones_table_regions'); ?></th>
                                        <th><?php echo EYHelper::i18n('excluded_zones_table_delete'); ?></th>
                                    </tr>
                                </thead>
                                <tbody class="wc-shipping-zone-method-rows ui-sortable ex-zones-table"></tbody>
                            </table>
                        </td>
                    </tr>

                </tbody>
            </table>

            <?php
            $this->form_fields = $this->excluded_zones_form($this->settings);
            parent::admin_options();
            ?>
        </div>
        <!-- end content -->

        <!-- content tag address -->
        <div class="tabcontent  enviaya-settings" id="enviaya-sender-addr">
            <?php
            $this->form_fields = $this->sender_addr_form($this->settings);
            parent::admin_options();

            $postal_code = isset($settings['origin_address']->postal_code) ?
                $settings['origin_address']->postal_code : null;
            $full_name = isset($settings['origin_address']->full_name) ?
                $settings['origin_address']->full_name : null;
            $phone = isset($settings['origin_address']->phone) ?
                $settings['origin_address']->phone : null;

            ?>
            <?php if (isset($adddr2)) { ?>

                <input type="hidden" name="postcode" id="adrhid_postcode" value="<?php echo $postal_code; ?>">
                <input type="hidden" name="fullname" id="adrhid_fullname" value="<?php echo $full_name; ?>">
                <input type="hidden" name="email" id="adrhid_phone" value="<?php echo $phone; ?>">

            <?php } ?>

            <table class="form-table">
                <tbody>
                    <tr valign="top">
                        <th scope="row" class="titledesc"></th>
                        <td class="forminp">
                            <div id="full_address">
                                <span class="adr_full_name"></span><br>
                                <span class="adr_phone"></span><br>
                                <span class="adr_email"></span><br>
                                <br>
                                <span class="adr_full_name"></span><br>
                                <span class="adr_full_name"></span><br>
                                <span class="adr_full_name"></span><br>
                                <span class="adr_full_name"></span><br>
                                <span class="adr_full_name"></span><br>
                                <span class="adr_full_name"></span><br>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <!-- end tag -->

        <!-- content tag technical-conf -->
        <div class="tabcontent enviaya-settings" id="enviaya-technical-conf">
            <?php
            $this->form_fields = $this->tech_conf_form($this->settings);
            parent::admin_options();
            ?>

            <script>var order_total_amount_success = '<?= EYHelper::i18n('delete_api_logs_success'); ?>';</script>
            <?php
            $this->form_fields = $this->status_form($this->settings);
            parent::admin_options();
            ?>
        </div>
        <!-- end content -->

        <!-- content tag status -->
        <div class="tabcontent  enviaya-settings" id="enviaya-status">
            <h3><?= EYHelper::i18n('status'); ?></h3>
            <p></p>

            <table class="form-table">
                <tr valign="top">
                    <th scope="row" class="titledesc">
                        <label><?= EYHelper::i18n('domain'); ?>:</label>
                    </th>
                    <td class="forminp">
                        <?php echo $server_name . '<br>'; ?>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row" class="titledesc">
                        <label><?= EYHelper::i18n('php_version'); ?></label>
                    </th>
                    <td class="forminp">
                        <?php echo $php_version . '<br>'; ?>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row" class="titledesc">
                        <label><?= EYHelper::i18n('wordpress_version'); ?></label>
                    </th>
                    <td class="forminp">
                        <?php echo $wp_version . '<br>'; ?>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row" class="titledesc">
                        <label><?= EYHelper::i18n('woocommerce_version'); ?></label>
                    </th>
                    <td class="forminp">
                        <?php echo  $wc_version . '<br>'; ?>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row" class="titledesc">
                        <label><?= EYHelper::i18n('curl_existence'); ?></label>
                    </th>
                    <td class="forminp">
                        <?php echo  $curl_exists . '<br>'; ?>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row" class="titledesc">
                        <label><?= EYHelper::i18n('support_code'); ?></label>
                        <span class="woocommerce-help-tip" data-tip="Send this code when requesting support"></span>
                    </th>
                    <td class="forminp">
                        <fieldset>
                            <input id="stringSupport" type="text" value="<?php echo $stringSupport; ?>" class="input-text regular-input">
                            <button onclick="copyToStringSupport(); return false;">
                                <?= EYHelper::i18n('copy'); ?>
                            </button>
                        </fieldset>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row" class="titledesc">
                        <label><?= EYHelper::i18n('download_logs'); ?>:</label>
                        <span class="woocommerce-help-tip"></span>
                    </th>
                    <td class="forminp">
                        <a href="/wp-content/debug.log" download="debug.log"><input type="button" style="-webkit-appearance: button;" value="<?= EYHelper::i18n('download_logs'); ?>"></a>
                    </td>
                </tr>
            </table>
        </div>
        <!-- end content -->

        <?php
            if (isset($_POST['save'])) :
                if ($_POST['save'] == 'excluded_zones') : ?>
                <script>
                    jQuery(document).ready(function() {
                        openTab(event, 'enviaya-excluded-zones');
                    });
                </script><?php
                endif;
            endif;
        ?>

    <?php
    }


    /**
        * @param array $settings
        * @return mixed
        */
    static function access_conf_form($settings = [])
    {
        $enviaya_accounts = [];
        $response = EYHelper::libAPI()->get_accounts(null);

        if (!isset($response->errors) && isset($response->enviaya_accounts)) {
            $acc_array = $response->enviaya_accounts;
        }

        if (isset($acc_array)) {
            foreach ($acc_array as $acc) {
                if ($acc->status == 'active') {
                    $enviaya_accounts[$acc->account] = $acc->alias . ' (' . $acc->account . ')';
                }
            }
        } else {
            $enviaya_accounts['none'] = EYHelper::i18n('to_retrieve_your_billing_accounts');
        }

        $setup_form['api_key_configuration'] = array(
            'title'       => EYHelper::i18n('api_key_configuration'),
            'type'        => 'title',
        );

        $setup_form['api_key_production'] = array(
            'title'       => EYHelper::i18n('api_key'),
            'type'        => 'text',
            'description' => EYHelper::i18n('api_key_help'),
            'default'     => '',
            'desc_tip'    => true,
        );

        $setup_form['api_key_test'] = array(
            'title'       => EYHelper::i18n('test_api_key'),
            'type'        => 'text',
            'description' => EYHelper::i18n('api_key_help'),
            'default'     => '',
            'desc_tip'    => true,
        );

        $setup_form['enabled_test_mode'] = array(
            'title'         => EYHelper::i18n('enable_test_mode'),
            'label' => ' ',
            'default' => EYHelper::i18n('no'),
            'type'          => 'checkbox',
            'description'   => EYHelper::i18n('test_mode_help'),
            'desc_tip'      => true,
        );

        $setup_form['hr_1'] = array(
            'type'        => 'title',
            'class'        => 'woocommerce_enviaya_hr'
        );

        $setup_form['billing_account'] = array(
            'title'       => EYHelper::i18n('billing_account'),
            'type'        => 'title',
        );

        // country list
        $countries_obj = new WC_Countries();
        $countries     = $countries_obj->get_countries();

        $setup_form['enviaya_account'] = array(
            'title'       => EYHelper::i18n('account'),
            'type'        => 'select',
            'class'       => 'wc-enhanced-select',
            'css'         => 'min-width:300px;',
            'description' => EYHelper::getReplacingKeyi18n('{#api_link#}', 'api_domain', 'billing_account_help'),
            'default'     => '',
            'options'     => $enviaya_accounts,
            'desc_tip'    => true,

        );

        return $setup_form;
    }

    /**
        * @param array $settings
        * @return mixed
        */
    static function rating_conf_form($settings = [])
    {
        $settings = EYHelper::settings();

        $setup_form['rating_configuration'] = array(
            'title'       => EYHelper::i18n('rating_configuration'),
            'type'        => 'title',
        );

        $setup_form['enable_rating']     = array(
            'title'       => EYHelper::i18n('enable_rating'),
            'type'        => 'select',
            'desc_tip'    => false,
            // 'default'     => $settings['enable_rating'],
            'description' => EYHelper::getReplacingKeyi18n('{#brand_name#}', 'brand_name', 'remove_rating_zones_hint'),
            'options'     => array(
                0           => EYHelper::i18n('no'),
                1           => EYHelper::i18n('yes')
            ),
        );

        $setup_form['hr_2'] = array(
            'type'        => 'title',
            'class'        => 'woocommerce_enviaya_hr'
        );

        // Shipping Services Design
        $setup_form['shipping_services_design'] = array(
            'title'       => EYHelper::i18n('shipping_services_display'),
            'type'        => 'title',
        );

        $setup_form['title_rating_configuration_' . get_locale()] = array(
            'title'              => EYHelper::i18n('title'),
            'type'               => 'text',
            'description'        => EYHelper::i18n('rates_title'),
            'desc_tip'    => true,
        );

        $setup_form['shipping_carrier_name']     = array(
            'title'       => EYHelper::i18n('carrier_name'),
            'type'        => 'select',
            'description' => EYHelper::i18n('carrier_name_help'),
            'desc_tip'    => true,
            'options'       => array(
                '0' => EYHelper::i18n('carrier_name_option_1'),
                '1' => EYHelper::i18n('carrier_name_option_2')
            ),
        );

        $setup_form['shipping_service_design_advanced']     = array(
            'title'       => EYHelper::i18n('service_name'),
            'type'        => 'select',
            'description' => EYHelper::i18n('service_name_help'),
            'default'     => '0',
            'desc_tip'    => true,
            'options'       => array(
                '0' => EYHelper::i18n('service_name_1'),
                '1' => EYHelper::i18n('service_name_2'),
                '2' => EYHelper::i18n('service_name_3'),
                '3' => EYHelper::i18n('service_name_4'),
            ),

        );

        $setup_form['shipping_delivery_time']     = array(
            'title'       => EYHelper::i18n('shipping_delivery_time'),
            'type'        => 'select',
            'description' => EYHelper::i18n('shipping_delivery_time_help'),
            'default'     => '0',
            'desc_tip'    => true,
            'options'       => array(
                '0' => EYHelper::i18n('show_estimated_delivery_date'),
                '1' => EYHelper::i18n('show_transit_time'),
                '2' => EYHelper::i18n('do_not_show_delivery_time'),
            ),
        );

        $setup_form['default_or_advanced_design'] = array(
            'title'       => EYHelper::i18n('shipping_services_design'),
            'type'        => 'select',
            'description' => '<div id=default_or_advanced_design_example></div>',
            'default'     => '0',
            'desc_tip'    => EYHelper::i18n('shipping_services_design_help'),
            'options'       => array(
                '0' => EYHelper::i18n('default_shipping_services_design'),
                '1' => EYHelper::i18n('advanced_shipping_services_design')
            ),
        );

        $setup_form['display_carrier_logo']     = array(
            'title'       => EYHelper::i18n('display_carrier_logo'),
            'type'        => 'select',
            'desc_tip'    => true,
            'options'       => array(
                '0' => EYHelper::i18n('no'),
                '1' => EYHelper::i18n('yes')
            ),
        );

        $pict = "<img id=pic0 src=https://enviaya-public.s3-us-west-1.amazonaws.com/images/99minutos.png
                    title=MINUTOS class=shipmen_logo style='padding: 1px;'>
                    <img id=pic1 src=https://enviaya-public.s3-us-west-1.amazonaws.com/images/ups.png
                    title=UPS class=shipmen_logo style='padding: 1px;'>
                    <img id=pic2 src=https://enviaya-public.s3-us-west-1.amazonaws.com/images/redpack.png
                    title=REDPACK class=shipmen_logo style=padding: 1px;>
                    <img id=pic3 src=https://enviaya-public.s3-us-west-1.amazonaws.com/images/fedex.png
                    title=FEDEX class=shipmen_logo style='padding: 1px;'>
                    <img id=pic4 src=https://enviaya-public.s3-us-west-1.amazonaws.com/images/dhl.jpg
                    title=DHL class=shipmen_logo style='padding: 1px;'>";

        $setup_form['shipping_service_design']     = array(
            'title'       => EYHelper::i18n('shipping_services_display'),
            'type'        => 'select',
            'default'     => '1',
            'description' => "<span id=span-example >" . EYHelper::i18n('shipping_services_design_example') . "</span>
                                <div class=block-span>
                                    <span id=span-image>{$pict}</span>
                                    <span id=block_design></span>
                                </div>",
            'options'       => array(
                '0' => EYHelper::i18n('advanced_shipping_services_design_1'),
                '1' => EYHelper::i18n('advanced_shipping_services_design_2'),
            ),
        );

        $setup_form['group_by_carrier']     = array(
            'title'       => EYHelper::i18n('group_by_carrier'),
            'type'        => 'select',
            'desc_tip'    => true,
            'options'       => array(
                '0' => EYHelper::i18n('no'),
                '1' => EYHelper::i18n('yes')
            ),
        );

        $setup_form['recomendation_shipping_services'] = array(
            'type'        => 'title',
            'description' => EYHelper::i18n('custom_design_text'),
        );

        $setup_form['hr_3'] = array(
            'type'        => 'title',
            'class'       => 'woocommerce_enviaya_hr'
        );

        // Free Shipping
        $setup_form['free_shipping'] = array(
            'title'       => EYHelper::i18n('free_shipping'),
            'type'        => 'title',
        );

        //Update settings
        EYHelper::updateSetting("account_id", EYHelper::getAccountId($settings['enviaya_account']));
        $settings = EYHelper::settings();

        //Recommendation: Enable Shipment Filters
        $setup_form['subsidies_hint'] = array(
            'title'       => '',
            'type'        => 'title',
            'description' => str_replace(
                ['{#api_link#}', '{#account_id#}'],
                [EYHelper::i18n('api_domain'), $settings['account_id']],
                EYHelper::i18n('free_shipping_text')
            ),
        );

        $setup_form['as_defined_price']     = array(
            'title'       => EYHelper::i18n('as_defined_price'),
            'type'        => 'select',
            'desc_tip'    => true,
            'default'     => '0',
            'options'       => array(
                '0' => EYHelper::i18n('do_not_show_price'),
                '1' => EYHelper::i18n('show_price_as'),
            ),
        );

        $setup_form['hr_4'] = array(
            'type'        => 'title',
            'class'       => 'woocommerce_enviaya_hr'
        );

        // Contingency Shipping
        $setup_form['contingency_shipping'] = array(
            'title'       => EYHelper::i18n('contingency_shipping_services'),
            'type'        => 'title',

        );

        $setup_form['enable_contingency_shipping']     = array(
            'title'       => EYHelper::i18n('enable_contingency_shipping_services'),
            'type'        => 'select',
            'default'     => '1',
            'desc_tip'    => EYHelper::i18n('contingency_services_help'),
            'options'       => array(
                '0' => EYHelper::i18n('no'),
                '1' => EYHelper::i18n('yes')
            ),
        );

        $setup_form['enable_standard_flat_rate'] = array(
            'title'       => EYHelper::i18n('contingency_standard_shipping'),
            'label' => ' ',
            'default'       => EYHelper::i18n('yes'),
            'type'          => 'checkbox',
            'desc_tip'      => false,
        );

        $setup_form['standard_flat_rate_title'] = array(
            'title'       => EYHelper::i18n('contingency_standard_shipping_title'),
            'type'        => 'text',
            'desc_tip'    => EYHelper::i18n('contingency_standard_shipping_help'),
            'default'     => EYHelper::i18n('contingency_standard_shipping_default'),
        );

        $setup_form['standard_flat_rate'] = array(
            'title'       => EYHelper::i18n('contingency_standard_rate'),
            'type'        => 'text',
            'description' => get_woocommerce_currency(),
            'default'     => '100',
            'desc_tip'    => EYHelper::i18n('contingency_standard_rate_help'),
        );

        $setup_form['enable_express_flat_rate'] = array(
            'title'       => EYHelper::i18n('contingency_express_shipping'),
            'label' => ' ',
            'default'       => EYHelper::i18n('yes'),
            'type'          => 'checkbox',
            'desc_tip'      => false,
        );

        $setup_form['express_flat_rate_title'] = array(
            'title'       => EYHelper::i18n('contingency_express_shipping_title'),
            'type'        => 'text',
            'default'    => EYHelper::i18n('contingency_express_shipping_default'),
            'desc_tip'    => EYHelper::i18n('contingency_express_shipping_help'),
        );

        $setup_form['express_flat_rate'] = array(
            'title'       => EYHelper::i18n('contingency_express_rate'),
            'type'        => 'text',
            'description' => get_woocommerce_currency(),
            'default'     => '150',
            'desc_tip'    => EYHelper::i18n('contingency_express_rate_help'),
        );

        $setup_form['hr_5'] = array(
            'type'        => 'title',
            'class'       => 'woocommerce_enviaya_hr'
        );


        //Recommendation: Additional account configurations
        $setup_form['recomendation_account_configurations'] = array(
            'title'       => EYHelper::i18n('additional_account_configurations_title'),
            'type'        => 'title',
            'description' => str_replace(
                ['{#api_link#}', '{#account_id#}'],
                [EYHelper::i18n('api_domain'), $settings['account_id']],
                EYHelper::i18n('additional_account_configurations_text')
            ),
        );

        $setup_form['hr_6'] = array(
            'type'        => 'title',
            'class'       => 'woocommerce_enviaya_hr'
        );

        //Recommendation: Enable Shipment Filters
        $setup_form['recomendation_shipment_filters'] = array(
            'title'       => EYHelper::i18n('carrier_and_services_configuration'),
            'type'        => 'title',
            'description' => str_replace(
                '{#api_link#}',
                EYHelper::i18n('api_domain'),
                EYHelper::i18n('carrier_and_services_configuration_help')
            ),
        );

        $setup_form['hr_7'] = array(
            'type'        => 'title',
            'class'       => 'woocommerce_enviaya_hr'
        );

        $setup_form['recomendation_subsidies'] = array(
            'title'       => EYHelper::i18n('subsidies_title'),
            'type'        => 'title',
            'description' => EYHelper::i18n('subsidies_text') . "<br><a target=_blank
                href=https://" . EYHelper::i18n('api_domain') . "/shipping/subsidy_amounts >" . EYHelper::i18n('subsidies_link_text') . " </a>",
        );

        $setup_form['hr_8'] = array(
            'type'        => 'title',
            'class'       => 'woocommerce_enviaya_hr'
        );

        $setup_form['additional_options'] = array(
            'title'       => EYHelper::i18n('additional_options'),
            'type'        => 'title',
        );

        $currency_code_options = get_woocommerce_currencies();

        foreach ($currency_code_options as $code => $name) {
            $currency_code_options[$code] = $name . ' (' . get_woocommerce_currency_symbol($code) . ')';
        }

        $setup_form['default_currency']     = array(
            'title'       => EYHelper::i18n('default_currency'),
            'type'        => 'select',
            'default'     => get_woocommerce_currency(),
            'desc_tip' => false,
            'options'     => $currency_code_options,
        );

        $setup_form['enable_currency_support'] = array(
            'title'       => EYHelper::i18n('enable_currency_support'),
            'label' => ' ',
            'default'     => EYHelper::i18n('no'),
            'type'          => 'checkbox',
            'description'   => "<span id=enable_currency_support_description>
                " . EYHelper::i18n('enable_currency_support_help') . "</span>",
            'desc_tip'    => false,
        );

        $setup_form['rate_on_add_to_cart']     = array(
            'title'       => EYHelper::i18n('rate_on_add_to_cart'),
            'type'        => 'select',
            'description' => EYHelper::i18n('rate_on_add_to_cart_info'),
            'default'     => '0',
            'desc_tip'    => EYHelper::i18n('rate_on_add_to_cart_help'),
            'options'     => array(
                '0' => EYHelper::i18n('no'),
                '1' => EYHelper::i18n('yes')
            ),
        );

        return $setup_form;
    }

    /**
        * @param array $settings
        * @return mixed
        */
    static function adv_conf_form($settings = [])
    {
        $setup_form['advanced_configuration'] = array(
            'title'       => EYHelper::i18n('advanced_configuration'),
            'type'        => 'title',
        );

        $setup_form['automatic_shipment_booking'] = array(
            'title'       => EYHelper::i18n('auto_shipment_booking'),
            'label' => ' ',
            'default'     => EYHelper::i18n('no'),
            'type'          => 'checkbox',
            'description'   => EYHelper::i18n('desc_shipment_booking'),
            'desc_tip'      => true,
        );

        $setup_form['doken_integration'] = array(
            'title'       => EYHelper::i18n('enable_dokan'),
            'label' => ' ',
            'default'     => EYHelper::i18n('yes'),
            'type'          => 'checkbox',
            'description'   => EYHelper::getReplacingKeyi18n('{#brand_name#}', 'brand_name', 'enable_dokan_help'),
            'desc_tip'      => true,
            // 'css'         => 'display: none;',
        );

        return $setup_form;
    }

    static function tech_conf_form($settings = [])
    {
        $setup_form['tech_configuration'] = array(
            'title'       => EYHelper::i18n('technical_configuration'),
            'type'        => 'title',

        );

        $setup_form['timeout'] = array(
            'title'       => EYHelper::i18n('timeout'),
            'type'        => 'text',
            'description' => EYHelper::i18n('timeout_help'),
            'default'     => '15',
            'desc_tip'    => true,
        );

        $setup_form['enable_api_logging'] = [
            'title'         => EYHelper::i18n('enable_api_logs'),
            'label'       => '<a href="'.esc_url( admin_url( 'admin.php?page=wc-status&tab=logs' ) ).'">'.EYHelper::i18n('logger_api_action').'</a>',
            'default' => EYHelper::i18n('no'),
            'type'          => 'checkbox',
            'description'   => EYHelper::i18n('enable_api_logs_help'),
            'desc_tip'      => true,
        ];

        return $setup_form;
    }

    /**
        * @param array $settings
        * @return mixed
        */
    static function status_form($settings = [])
    {
        $setup_form['total_remove'] = array(
            'title'         => EYHelper::i18n('remove_all_settings_and_data'),
            'label' => ' ',
            'default' => EYHelper::i18n('no'),
            'type'          => 'checkbox',
            'description'   => EYHelper::i18n('remove_all_settings_and_data_help'),
            'desc_tip'      => true,
        );

        return $setup_form;
    }

    /**
        * @param array $settings
        * @return mixed
        */
    static function excluded_zones_form_title($settings = [])
    {
        $setup_form['tech_excluded_zones'] = array(
            'title'       => EYHelper::i18n('excluded_zones_title'),
            'type'        => 'title',
            'description'   => EYHelper::i18n('excluded_zones_title_help'),
        );

        return $setup_form;
    }

    /**
        * @param array $settings
        * @return mixed
        */
    static function excluded_zones_form($settings = [])
    {
        $setup_form['excluded_zones_data'] = array(
            'type'  => 'hidden',
            'default' => [],
        );

        return $setup_form;
    }

    /**
        * @param array $settings
        * @return mixed
        */
    static function sender_addr_form($settings = [])
    {
        $setup_form['sender_addr'] = array(
            'title'       => EYHelper::i18n('sender_address'),
            'type'        => 'title',

        );

        //origin addresses list
        $origin_addresses = [];
        $props = [
            'param' => '&get_origins=t',
        ];
        $response = EYHelper::libAPI()->directions($props);

        if (isset($response->directions) && !isset($response->errors)) {
            foreach ($response->directions as $address) {
                $ord_adr = json_encode($address);
                $ord_adr = str_replace('"', '||', $ord_adr);
                $origin_addresses[$ord_adr] = !empty($address->full_name) ? $address->full_name :
                    $address->company;
            }
        } else {
            $origin_addresses['{}'] = EYHelper::i18n('get_origin_addresses');
        }


        $setup_form['origin_address'] = array(
            'title'       => EYHelper::i18n('sender_address'),
            'type'        => 'select',
            'class'    => 'wc-enhanced-select',
            'css'      => 'min-width:300px;',
            'description' => '<a href="https://app.' . EYHelper::i18n('api_domain') . '/directions/new?origin=true"
                target="_blank">' . EYHelper::i18n('add_new_sender') . '</a> <div></div>',
            'default'     => '',
            'options'   => $origin_addresses,
        );

        return $setup_form;
    }

    public function get_shipping_to_display(){
      return 'test';
    }
} //end class
