//Obtiene productos
let productos
const obtenerProductosExternos = async() => {
    try {
        const res = await fetch(blog_url + '/wp-json/wp/v2/productosexternos?per_page=100&_embed');
        productosExternos = await res.json();
        productos = [...productos, ...productosExternos];
        // console.log(productos)
        printProductos();
    } catch (error) {
        console.log(error);
    }
}
const obtenerProductos = () => {
    $.ajax({
        url: aj_ajax.ajaxurl,
        type: 'post',
        data: {
            'action': 'actionFiltroTienda',
        },
        success: function (resp) {
            resp = JSON.parse(resp)
            // console.log(resp)
            productos = resp
            obtenerProductosExternos()
        },
        error: function (jqXHR, estado, error) {
           
        },
        complete: function (jqXHR, estado) {

        }
    })
}
obtenerProductos()

const creaProducto = (producto, index, imagePreview) => (
    (producto.type != "productosexternos")?`<a href="${producto.link}" class="item">
        <img src="${producto.post_thumbnail}" alt="">
        <div class="contenedor-hover">
            <h4>${producto.post_title}</h4>
            <div class="price-product">${producto.price}</div>
        </div>
        <div class="contenedor-titulo-mobile">
            <h4>${producto.post_title}</h4>
            <div class="price-product">${producto.price}</div>
        </div>
    </a>`:`<a target="_blank" href="${producto.acf.general.link}" class="item">
        <img src="${imagePreview}" alt="">
        <div class="contenedor-hover">
            <h4>${producto.title.rendered}</h4>
        </div>
        <div class="contenedor-titulo-mobile">
            <h4>${producto.title.rendered}</h4>
        </div>
    </a>`
)

const printProductos = (productosFiltrados = null) => {
    if(!productosFiltrados){
        productosFiltrados = productos;
    }
    if(productosFiltrados){
        $('.contenedor-productos .main-container .contenedor-productos-grid').empty();
        productosFiltrados.map((producto, index) => {
            let imagePreview = '';
            if(producto.type == 'productosexternos'){
                if(producto._embedded['wp:featuredmedia']){
                    imagePreview = producto._embedded['wp:featuredmedia'][0].media_details.sizes.medium_large.source_url;
                }
            }
            $('.contenedor-productos .main-container .contenedor-productos-grid').append(creaProducto(producto, index, imagePreview));
        })
    }
}

$('[data-filtro]').click((e) => {
    e.preventDefault()
    activeFiltro(e.currentTarget)
    filtraProductos($(e.currentTarget).attr('data-filtro'))
});
const activeFiltro = (element) => {
    $('[data-filtro]').removeClass('active')
    $(element).addClass('active')
    drawFilter(element)
}

const filtraProductos = (id) => {
    if(id == 0){
        printProductos()
    }else{
        let filterProductos = []
        productos.map((producto, index) => {
            if(producto.type == 'product'){
                producto.terms.map(categoria => {
                    if(categoria.term_id == id){
                        filterProductos = [...filterProductos, producto]
                    }
                })
            }else{
                if(producto.type == id){
                    filterProductos = [...filterProductos, producto]
                }
            }
        });
        printProductos(filterProductos)
    }
}
///////////////////////////////////////////////////
const drawFilter = (element) => {
    $('.contenedor-filtro .item').each((index, item) => {
        if(item == element){
            gsap.timeline().to(item.children[1].children[0].children[0], {
                duration: 0.3,
                stagger: 0.1,
                drawSVG: '100%'
            });
        }else{
            gsap.timeline().to(item.children[1].children[0].children[0], {
                duration: 0.3,
                stagger: 0.1,
                drawSVG: '0'
            });
        }
    })
}
const drawFilterInicial = () => {
    gsap.timeline().to(".contenedor-filtro .item.active .circle-draw", {
        duration: 0.3,
        stagger: 0.1,
        drawSVG: '100%'
    });
}
drawFilterInicial()
///////////////////////////////////////////////////