<?php
namespace App\DTOs\Auth;

class RegisterDTO
{
    public string $name;
    public string $email;
    public string $password;
    public string $rol_name;
    public bool $active;

    public function __construct(array $data)
    {
        $this->name = $data['name'];
        $this->email = $data['email'];
        $this->password = $data['password'];
        $this->rol_name = $data['rol_name'];
        $this->active = $data['active'] ?? true;
    }

    public static function fromRequest(\Illuminate\Http\Request $request): self
    {
        return new self($request->only(['email', 'password', 'name', 'rol_name', 'active']));
    }

    public function toArray(): array
    {
        return [
            'name' => $this->name,
            'email' => $this->email,
            'password' => $this->password,
            'rol_name' => $this->rol_name,
            'active' => $this->active,
        ];
    }
}