<?php

namespace App\DTOs\Comment;

use Illuminate\Http\Request;

class CommentCreateDto
{
    public string $body;
    public int $lead_id;
    public int $user_id;

    public function __construct(array $data)
    {
        $this->body = $data['body'];
        $this->lead_id = $data['lead_id'];
        $this->user_id = $data['user_id'];
    }

    public static function fromRequest(Request $request): self
    {
        return new self($request->only(['body', 'lead_id']));
    }

    public function toArray(): array
    {
        return [
            'body' => $this->body,
            'lead_id' => $this->lead_id,
            'user_id' => $this->user_id,
        ];
    }
}