<?php

namespace App\DTOs\Dashboard;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;

class FilterRangeDateDTO
{
    public function __construct(
        public readonly ?Carbon $startDate,
        public readonly ?Carbon $endDate,
        public readonly int $limit = 6
    ) {
    }

    public static function fromRequest(array $data): self
    {
        return new self(
            startDate: isset($data['start_date'])
            ? Carbon::parse($data['start_date'])->startOfDay()
            : null,

            endDate: isset($data['end_date'])
            ? Carbon::parse($data['end_date'])->endOfDay()
            : null
        );
    }

    public function hasDateRange(): bool
    {
        return $this->startDate && $this->endDate;
    }

    public function getCacheKey(): string
    {
        $version = Cache::get('leads_cache_version', 1);

        return 'leads_recent_v' . $version . '_' . md5(json_encode([
            'start' => $this->startDate?->toDateString(),
            'end' => $this->endDate?->toDateString(),
            'limit' => $this->limit,
        ]));
    }
}