<?php

namespace App\DTOs\LeadType;

use Illuminate\Http\Request;

class LeadTypeCreateDTO
{
    public string $name;
    public string $background_color;
    public bool $active;

    public function __construct(array $data)
    {
        $this->name = $data['name'];
        $this->background_color = $data['background_color'] ?? null;
        $this->active = $data['active'] ?? true;
    }
    
    public static function fromRequest(Request $request): self
    {
        return new self($request->only(['name', 'active', 'background_color']));
    }

    public function toArray(): array
    {
        return [
            'name' => $this->name,
            'background_color' => $this->background_color,
            'active' => $this->active,
        ];
    }
}