<?php
namespace App\DTOs\Staft;

use App\Models\User;

class StaftDetailDto
{
    public function __construct(
        public readonly int $id,
        public readonly string $name,
        public readonly string $last_name,
        public readonly string $email,
        public readonly ?string $phone,
        public readonly ?string $department_id,
        public readonly int|string|null $lead_type_id,
        public readonly ?string $photoUrl,
        public readonly string $role,
        public readonly bool $active,
    ) {}

    public static function fromModel(User $user): self
    {
        $lastName = $user->staftDetail?->last_name;
        $roleName = $user->roles->first()->name ?? null;
        $phone = $user->staftDetail?->phone;
        $photoUrl = $user->staftDetail?->documents->first()->file_path ?? null;
        $department_id = $user->staftDetail?->department_id ?? null;

        $leads = $user->leadTypes;
        $calculatedLeadId = match (true) {
            $leads->count() > 1 => 0,
            $leads->count() === 1 => $leads->first()->id,
            default => null
        };


        return new self(
            id: $user->id,
            name: $user->name,
            last_name: $lastName,
            email: $user->email,
            phone: $phone,
            department_id: $department_id,
            lead_type_id: $calculatedLeadId,
            role: $roleName,
            photoUrl: $photoUrl,
            active: (bool) $user->active,
        );
    }
}