<?php

namespace App\DTOs\Venue;

class VenueCreateDto
{
    public function __construct(
        public readonly string $name,
        public readonly int $ability,
        public readonly ?bool $active = null,
    ) {}

    public function toArray(): array
    {
        return [
            'name' => $this->name,
            'ability' => $this->ability,
            'active' => $this->active ?? true,
        ];
    }
}