<?php

namespace App\Http\Controllers\Document;

use App\Http\Controllers\Controller;
use App\Services\DocumentService;
use App\Services\LeadService;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use ZipArchive;

class DocumentController extends Controller
{

    public function __construct(protected DocumentService $documentService, protected LeadService $leadService)
    {

    }

    public function download(int $document_id)
    {
        $document = $this->documentService->find($document_id);
        if(!$document){
            return redirect()->back()->withErrors(['error' => 'Lo sentimos, tuvimos un error al encontrar el archivo.']);
        }
        if (!Storage::disk('public')->exists($document->file_path)) {
            return redirect()->back()->withErrors(['error' => 'El archivo solicitado no existe.']);
        }
        $fullPath = Storage::disk('public')->path($document->file_path);
        return response()->download($fullPath, $document->file_name);
    }

    public function downloadAllDocuments(int $lead_id)
    {
        $lead = $this->leadService->find($lead_id);
        if (!$lead) {
            return redirect()->back()->withErrors(['error' => 'Lo sentimos, tuvimos un error al obtener los archivos del lead.']);
        }
        $documents = $this->documentService->getCommentDocumentsForLead($lead);

        if ($documents->isEmpty()) {
            redirect()->back()->withErrors(['error' => 'No hay archivos adjuntos para este lead.']);
        }

        $zipFileName = 'documentos' . '_' . Str::random(6) . '.zip';
        $zipPath = tempnam(sys_get_temp_dir(), 'zip_download') . '.zip';
        $zip = new ZipArchive;
        if ($zip->open($zipPath, ZipArchive::CREATE) === TRUE) {
            foreach ($documents as $document) {
                $filePath = Storage::disk('public')->path($document->file_path);
                if (file_exists($filePath)) {
                    $zip->addFile($filePath, $document->file_name);
                }
            }
            $zip->close();
            return response()->download($zipPath, $zipFileName)->deleteFileAfterSend(true);
        }
        return redirect()->back()->withErrors(['error' => 'Ocurrió un error al crear el archivo de descarga.']);
    }
}
