<?php

namespace App\Http\Controllers;

use App\DTOs\Dashboard\FilterRangeDateDTO;
use App\Http\Requests\Dashboard\DashboardFilterRequest;
use App\Services\DashboardService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class HomeController extends Controller
{
    public function __construct(protected DashboardService $dashboardService)
    {
    }

    public function index(DashboardFilterRequest $request): View
    {
        $filters = $request->validated();
        $startDate = $filters['start_date'] ?? null;
        $endDate = $filters['end_date'] ?? null;

        $filtersDto = FilterRangeDateDTO::fromRequest($request->validated());

        $stats = $this->dashboardService->getStats($filtersDto);
        $recentLeads = $stats['leadsRecent'];

        $labelsArea = ['Jan', 'Feb', 'Mar', 'Apr', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
        $chartDataArea = [
            [
                'label' => 'Tiempo de cierre',
                'data' => [10, 5, 15, 20, 12, 18, 5, 8, 12, 10, 15, 12],
                'borderColor' => '#3b82f6',
                'backgroundColor' => 'rgba(59, 130, 246, 0.1)',
            ],
            [
                'label' => 'Referencia',
                'data' => [5, 12, 8, 15, 25, 10, 12, 5, 8, 15, 10, 14],
                'borderColor' => '#93c5fd',
                'backgroundColor' => 'rgba(147, 197, 253, 0.05)',
            ]
        ];

        return view("home", compact('startDate', 'endDate', 'recentLeads', 'labelsArea', 'chartDataArea'));
    }

    public function getLeadTypeStats(DashboardFilterRequest $request)
    {
        $filtersDto = FilterRangeDateDTO::fromRequest($request->validated());
        $chartData = $this->dashboardService->getLeadTypeStats($filtersDto);

        return response()->json($chartData);
    }

    public function getMonthlyEvents(): JsonResponse
    {
        return response()->json($this->dashboardService->getMonthlyEventStats());
    }

    public function getTotalLeads(DashboardFilterRequest $request): JsonResponse
    {
        $filtersDto = FilterRangeDateDTO::fromRequest($request->validated());
        return response()->json($this->dashboardService->getTotalLeadsCount($filtersDto));
    }

    public function getTotalSales(DashboardFilterRequest $request): JsonResponse
    {
        $filtersDto = FilterRangeDateDTO::fromRequest($request->validated());
        $data = $this->dashboardService->getTotalSales($filtersDto);

        return response()->json($data);
    }
}