<?php

namespace App\Http\Controllers\Report;

use App\DTOs\Report\FilterReportLeadsDTO;
use App\Http\Controllers\Controller;
use App\Http\Requests\Report\FilterLeadReportRequest;
use App\Services\LeadService;
use App\Services\LeadTypeService;
use App\Services\ReportService;
use App\Services\StaftService;
use App\Services\StatusPipelineService;
use Illuminate\Http\Request;
use Illuminate\View\View;

class ReportController extends Controller
{
    public function __construct(
        protected LeadService $leadService,
        protected StatusPipelineService $statusPipelineService,
        protected LeadTypeService $leadTypeService,
        protected StaftService $staftService,
        protected ReportService $reportService
    ) {
    }

    public function index(FilterLeadReportRequest $request): View
    {
        $filterDto = FilterReportLeadsDTO::fromRequest($request->validated());
        $leadTypes = $this->leadTypeService->get();
        $typesPipelines = $this->statusPipelineService->get();
        $staftList = $this->staftService->get(['superadmin']);
        $listReportLeads = $this->reportService->getLeadsReportByFilters($filterDto);
        // dd($listReportLeads);
        return view('reports.index', compact('leadTypes', 'typesPipelines', 'staftList', 'listReportLeads'));
    }
}