<?php

namespace App\Http\Controllers\Superadmin;

use App\DTOs\LeadType\LeadTypeCreateDTO;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\TypeLeadCreateRequest;
use App\Http\Requests\Admin\TypeLeadUpdateRequest;
use App\Services\LeadTypeService;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;

class TypeLeadController extends Controller
{
    public function __construct(protected LeadTypeService $leadTypeService)
    {
    }

    public function index(): View
    {
        $listData = $this->leadTypeService->getPaginated();
        return view('superadmin.leadtypes.index', compact('listData'));
    }

    public function create(): View
    {
        return view('superadmin.leadtypes.create');
    }

    public function edit($id): View
    {
        $editData = $this->leadTypeService->find($id);
        if (!$editData) {
            abort(404);
        }
        return view('superadmin.leadtypes.edit', compact('editData'));
    }

    public function store(TypeLeadCreateRequest $request): RedirectResponse
    {
        $dto = new LeadTypeCreateDTO($request->validated());
        $job = $this->leadTypeService->create($dto);

        if (!$job) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['error' => 'Ocurrió un error al guardar el tipo de evento. Intenta nuevamente.']);
        }

        return redirect()->route('superadmin.leadtypes.index')->with('success', 'Tipo de evento creado correctamente.');
    }

    public function update(TypeLeadUpdateRequest $request, $id): RedirectResponse
    {
        $dto = new LeadTypeCreateDTO($request->validated());
        $job = $this->leadTypeService->update($id, $dto);

        if (!$job) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['error' => 'No se pudo actualizar el tipo de evento.']);
        }

        return redirect()->route('superadmin.leadtypes.index')->with('success', 'Tipo de evento actualizado correctamente.');
    }

    public function destroy($id): RedirectResponse
    {
        $deleted = $this->leadTypeService->delete($id);
        if ($deleted) {
            return redirect()->route('superadmin.leadtypes.index')->with('success', 'Tipo de evento eliminado correctamente.');
        }
        return redirect()->route('superadmin.leadtypes.index')->with('error', 'No se pudo eliminar el tipo de evento.');
    }
}
