<?php

namespace App\Http\Controllers\User;

use App\DTOs\Auth\UpdatePasswordDTO;
use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\UpdatePasswordRequest;
use App\Services\UserService;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class UserController extends Controller
{
    public function __construct(protected UserService $userService){

    }

    public function showPasswordUpdate($id): View{
        $userFind = $this->userService->getUserById($id);
        if(!$userFind){
            abort(404);
        }
        return view("auth.password-update", compact('id'));
    }

    public function updatePassword(UpdatePasswordRequest $request, string $id): RedirectResponse
    {
        $userFind = $this->userService->getUserById($id);
        if(!$userFind){
            return redirect()->back()
                ->withErrors(['error' => 'El staft a actualizar no existe.']);
        }
        $dto = UpdatePasswordDTO::fromArray([
            'new_password' => $request->validated('new_password'),
        ]);
        $success = $this->userService->updatePassword($userFind->id, $dto);

        if (!$success) {
           return redirect()->back()
                ->withInput()
                ->withErrors(['error' => 'No se pudo actualizar la contraseña. Intenta nuevamente.']);
        }
        return redirect()->route('admin.stafts.edit', $userFind->id)->with('success', "Contraseña Actualizada correctamente");
    }
}
