<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class StatusPipelineCreateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name_status' => ['required', 'string', 'max:255', 'unique:status_pipelines,name_status'],
            'color' => ['required', 'string', 'regex:/^#([a-f0-9]{6})$/i'], 
            'background_color' => ['required', 'string', 'regex:/^#([a-f0-9]{6})$/i'],
        ];
    }

    public function messages(): array
    {
        return [
            'name_status.unique' => 'Ya existe un estado con este nombre.',
            'name_status.required' => 'El nombre de estado es requerido.',
            'color.regex' => 'El color primario debe ser un código hexadecimal válido (ej: #FFFFFF).',
            'color.required' => 'El color primario es requerido.',
            'background_color.regex' => 'El color base debe ser un código hexadecimal válido (ej: #000000).',
            'background_color.required' => 'El color base es requerido',
        ];
    }
}
