<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StatusPipelineUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        // $statusPipelineId = $this->route('id');

        return [
            'name_edit' => [
                'required',
                'string',
                'max:255',
                // Rule::unique('status_pipelines', 'name_status')->ignore($statusPipelineId),
            ],
            'color_edit' => ['required', 'string', 'regex:/^#([a-f0-9]{6})$/i'],
            'background_color_edit' => ['required', 'string', 'regex:/^#([a-f0-9]{6})$/i'],
        ];
    }

    public function messages(): array
    {
        return [
            'name_edit.required' => 'El nombre es obligatorio.',
            'name_edit.string' => 'El nombre debe ser una cadena de texto.',
            'name_edit.max' => 'El nombre no puede exceder los 255 caracteres.',
            'name_edit.unique' => 'Ya existe un estado con este nombre.',

            'color_edit.required' => 'El color primario es obligatorio.',
            'color_edit.string' => 'El color primario debe ser una cadena de texto.',
            'color_edit.regex' => 'El campo primario color debe ser un código hexadecimal válido (ej: #FFFFFF).',

            'background_color_edit.required' => 'El color base es obligatorio.',
            'background_color_edit.string' => 'El color base debe ser una cadena de texto.',
            'background_color_edit.regex' => 'El color base debe ser un código hexadecimal válido (ej: #000000).',
        ];
    }
}