<?php

namespace App\Http\Requests\Auth;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Hash;

class UpdatePasswordRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check();
    }

    public function rules(): array
    {
        $rules = [
            'new_password' => [
                'required',
                'string',
                'min:8',
                'confirmed',
                'max:255',
            ],
        ];
        return $rules;
    }

    public function withValidator($validator)
    {
        $idRoute = $this->route('id');
        $validator->after(function ($validator) use ($idRoute) {
            $user = User::find($this->route('id'));
            if (Hash::check($this->new_password, $user->password)) {
                $validator->errors()->add('new_password', 'La nueva contraseña no puede ser igual a la anterior.');
            }
        });
    }

    public function messages(): array
    {
        return [
            'new_password.required' => 'La nueva contraseña es requerida.',
            'new_password.confirmed' => 'La confirmación de la nueva contraseña no coincide.',
            'new_password.min' => 'La nueva contraseña debe tener al menos 8 caracteres.',
        ];
    }
}
