<?php

namespace App\Http\Requests\Comment;

use Illuminate\Foundation\Http\FormRequest;

class CommentCreateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'body' => ['required', 'string', 'max:500'],
            'lead_id' => ['required', 'integer', 'exists:leads,id'],
            'attachments' => ['nullable', 'array', 'max:5'],
            'attachments.*' => [
                'file',
                'max:5048',
                'mimes:jpg,jpeg,png,webp,pdf,doc,docx,xlsx,xls',
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'body.required' => 'El comentario es obligatorio.',
            'body.max' => 'El comentario solo pude tener un máximo de :max carácteres.',
            'lead_id.required' => 'El ID del lead es obligatorio.',
            'lead_id.exists' => 'El lead especificado no existe.',
            'attachments.max' => 'Solo puedes subir un máximo de :max archivos.',
            'attachments.*.file' => 'Uno de los archivos subidos no es un archivo válido.',
            'attachments.*.max' => 'El tamaño máximo de cada archivo es de 5MB.',
            'attachments.*.mimes' => 'Solo se permiten archivos de tipo imagen, PDF o documentos de Office.',
        ];
    }

    protected function prepareForValidation(): void
    {
        $leadId = $this->route('lead'); 
        if ($leadId) {
            $this->merge([
                'lead_id' => $leadId,
            ]);
        }
    }
}
