<?php

namespace App\Http\Requests\Report;

use Illuminate\Foundation\Http\FormRequest;

class FilterLeadReportRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'type_event' => [
                'nullable',
                'string',
                'max:255',
            ],
            'state_event' => [
                'nullable',
                'string',
                'max:255',
            ],
            'staft_name' => [
                'nullable',
                'string',
                'max:255',
            ],
        ];
    }
    
    protected function prepareForValidation(): void
    {
        $this->merge([
            'type_event' => $this->type_event ?: null,
            'state_event' => $this->state_event ?: null,
            'staft_name' => $this->staft_name ?: null,
        ]);
    }
}
