<?php

namespace App\Http\Requests\StatusPipeline;

use Illuminate\Foundation\Http\FormRequest;

class ReorderStatusPipelinesRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'item_id' => ['required', 'array'],
            'item_id.*' => ['required', 'integer', 'exists:status_pipelines,id'],
            'item_order' => ['required', 'array'],
            'item_order.*' => ['required', 'integer', 'min:1'],
        ];
    }

    public function items(): array
    {
        $ids = $this->validated('item_id');
        $orders = $this->validated('item_order');
        $items = [];
        $count = min(count($ids), count($orders));
        for ($i = 0; $i < $count; $i++) {
            $items[] = [
                'id' => $ids[$i],
                'order' => $orders[$i],
            ];
        }

        return $items;
    }
}
