<?php

namespace App\Http\Resources\Lead;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LeadListResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'                    => $this->slug,
            'name_event'            => $this->name_event,
            'full_name_user_target' => trim("{$this->name} {$this->last_name}"),
            'name_lead_type'        => $this->leadType?->name,
            'status_pipeline'       => $this->statusPipeline,
            'venue_name'            => $this->venue?->name,
        ];
    }
}
