<?php

namespace App\Http\Resources\Report;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LeadReportResource extends JsonResource
{
   public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name_event' => $this->name_event,
            'name_lead_type' => $this->leadType?->name ?? 'N/A',
            'estimated_budget' => '$' . number_format($this->estimated_budget, 2),
            'total_cost' => '$' . number_format($this->total_cost, 2),
            'status_html' => $this->resolveStatusHtml(),
        ];
    }

    private function resolveStatusHtml(): string
    {
        if (!$this->statusPipeline) return '';

        $bg = $this->statusPipeline->background_color;
        $color = $this->statusPipeline->color;
        $name = e($this->statusPipeline->name_status);

        return <<<HTML
            <p class="inline-flex items-center p-2 text-parrafo gap-x-2 rounded-3xl" 
               style="color: {$color}; background-color: {$bg};">
                <span class="block w-2 h-2 rounded-full bg-current"></span>
                <span>{$name}</span>
            </p>
        HTML;
    }
}
