<?php

namespace App\Observers;

use App\Models\Lead;
use Illuminate\Support\Facades\Cache;
use Log;

class LeadObserver
{
    private function invalidateCache(): void
    {
        Cache::forever('leads_cache_version', now()->timestamp);
    }

    public function created(Lead $lead): void
    {
        $this->invalidateCache();
    }

    public function updated(Lead $lead): void
    {
        if ($lead->wasChanged()) {
            $this->invalidateCache();
        }
    }

    public function deleted(Lead $lead): void
    {
        $this->invalidateCache();
    }

    /**
     * Handle the Lead "restored" event.
     */
    public function restored(Lead $lead): void
    {
        //
    }

    /**
     * Handle the Lead "force deleted" event.
     */
    public function forceDeleted(Lead $lead): void
    {
        //
    }
}
