<?php
namespace App\Queries;

use App\DTOs\Report\FilterReportLeadsDTO;
use App\Models\Lead;
use Illuminate\Database\Eloquent\Builder;

class LeadFilterReportQuery
{
    public static function build(FilterReportLeadsDTO $filters): Builder
    {
        $query = Lead::query()
            ->select([
                'id',
                'name',
                'last_name',
                'name_event',
                'slug',
                'estimated_budget',
                'total_cost',
                'lead_type_id',
                'status_pipeline_id'
            ])
            ->with([
                'leadType:id,name',
                'statusPipeline:id,name_status,color,background_color',
            ]);

        $query->when($filters->type_event ?? null, function ($q, $typeId) {
            return $q->where('lead_type_id', $typeId);
        });

        $query->when($filters->state_event ?? null, function ($q, $statusId) {
            return $q->where('status_pipeline_id', $statusId);
        });

        $query->when($filters->staft_name, function ($q, $staffId) {
            return $q->whereHas('assignedUsers', function ($subQuery) use ($staffId) {
                $subQuery->where('users.id', $staffId);
            });
        });

        return $query->latest();
    }
}