<?php
namespace App\Queries;

use App\Models\Lead;
use Illuminate\Database\Eloquent\Builder;

class LeadListByUser
{
    public static function build(string $user_id): Builder
    {
        $query = Lead::query()
            ->select([
                'id',
                'name',
                'last_name',
                'name_event',
                'lead_type_id',
                'status_pipeline_id',
            ])
            ->with([
                'leadType:id,name',
                'statusPipeline:id,name_status,color,background_color',
                'assignedUsers' => function ($q) use ($user_id) {
                    $q->where('users.id', $user_id);
                }
            ]);

        $query->whereHas('assignedUsers', function ($q) use ($user_id) {
            $q->where('users.id', $user_id);
        });

        return $query->latest();
    }
}