<?php
namespace App\Queries;

use App\Models\Lead;
use App\Models\User;
use Illuminate\Database\Eloquent\Builder;

class LeadListQuery
{
    public static function build(User $user, array $filters = []): Builder
    {
        $query = Lead::query()
            ->select([
                'id', 'name', 'last_name', 'name_event', 'slug',
                'lead_type_id', 'status_pipeline_id', 'venue_id'
            ])
            ->with([
                'leadType:id,name',
                'statusPipeline:id,name_status,color,background_color',
                'venue:id,name'
            ]);

        if (!$user->hasAnyRole(['admin', 'superadmin'])) {
            $query->whereHas('assignedUsers', function ($q) use ($user) {
                $q->where('users.id', $user->id);
            });
        }

        $query->when($filters['type_event'] ?? null, function ($q, $typeId) {
            return $q->where('lead_type_id', $typeId);
        });

        $query->when($filters['state_event'] ?? null, function ($q, $statusId) {
            return $q->where('status_pipeline_id', $statusId);
        });

        $query->when($filters['venue_id'] ?? null, function ($q, $venueId) {
            return $q->where('venue_id', $venueId);
        });

        return $query->latest();
    }
}