<?php
namespace App\Queries;

use App\Models\User;
use Illuminate\Database\Eloquent\Builder;

class StaftPaginateListQuery
{
    public static function build(array $filters = []): Builder
    {
        $query = User::select(['id', 'name', 'active'])
            ->with([
                'staftDetail:user_id,department_id,last_name',
                'staftDetail.department:id,name',
                'roles:id,display_name',
                'staftDetail.documents:documentable_id,file_path'
            ])
            ->whereDoesntHave('roles', function ($query) {
                $query->where('name', 'superadmin');
            });

        $query->when($filters['type_event'] ?? null, function ($q, $typeId) {
            $q->whereHas('leadTypes', function ($sq) use ($typeId) {
                $sq->where('lead_types.id', $typeId);
            });
        });

        $query->when(isset($filters['state_active']), function ($q) use ($filters) {
            $status = $filters['state_active'];
            if ($status === 'activo') {
                return $q->where('active', 1);
            }
            if ($status === 'inactivo') {
                return $q->where('active', 0);
            }
            return $q;
        });

        return $query->orderBy('name', 'asc');
    }
}