<?php

namespace App\Services;

use App\Models\Comment;
use App\Models\Document;
use App\Models\Lead;
use Illuminate\Support\Collection;
use Exception;
use Illuminate\Support\Facades\Log;

class DocumentService
{
    public function find(int $id): ?Document
    {
        try {
            return Document::find($id);
        } catch (Exception $e) {
            Log::error('Error al encontrar documento: ' . $e->getMessage(), [
                'data' => $id,
                'trace' => $e->getTraceAsString(),
            ]);
            return null;
        }
    }

    public function getCommentDocumentsForLead(Lead $lead): Collection
    {
        try {
            $commentIds = $lead->comments()->pluck('id');
            $documents = Document::query()
                ->where('documentable_type', Comment::class)
                ->whereIn('documentable_id', $commentIds)
                ->get();
            return $documents;
        } catch (Exception $e) {
            Log::error('Error al obtener los documentos ligados al comentario del lead.', [
                'lead_id' => $lead->id,
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
            return collect();
        }
    }
}