<?php
namespace App\Support;

class OperationResult
{
    public function __construct(
        protected bool $success,
        protected ?string $message = null,
        protected mixed $data = null
    ) {}

    public static function success(mixed $data = null, ?string $message = null): self
    {
        return new self(true, $message, $data);
    }

    public static function error(string $message, mixed $data = null): self
    {
        return new self(false, $message, $data);
    }

    public function succeeded(): bool
    {
        return $this->success;
    }

    public function failed(): bool
    {
        return !$this->success;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function getData(): mixed
    {
        return $this->data;
    }
}