<?php
use App\Http\Controllers\Lead\LeadController;
use Illuminate\Support\Facades\Route;


Route::middleware(['auth', 'role:superadmin|admin|staft'])->group(function () {
    Route::prefix('leads')->name('leads.')->group(function () {
        Route::get('/create', [LeadController::class, 'create'])->name('create');
        Route::get('/', [LeadController::class, 'index'])->name('index');

        Route::get('{lead_id}/timeline', [LeadController::class, 'getTimelineAjax'])
            ->name('timeline.ajax');

        Route::get('/{id}/edit', [LeadController::class, 'edit'])->name('edit');

        Route::post('/', [LeadController::class, 'store'])->name('store');
        Route::put('/{id}', [LeadController::class, 'update'])->name('update');

        Route::post('/{lead}/comments', [LeadController::class, 'storeComment'])
            ->name('comments.store');
    });
});