<?php
namespace App\DTOs\Guest;
use Illuminate\Http\Request;

class CreateGuestDTO
{
    public string $name;
    public string $email;
    public ?string $phone;
    public string $maxGuests;

    /**
     * @param string $name Nombre del invitado.
     * @param string $email Email del invitado (se asume que es obligatorio).
     * @param string|null $phone Número de teléfono, opcional.
     * @param int $maxGuests Número máximo de acompañantes que puede traer el invitado.
     */
    public function __construct(array $data)
    {
        $this->name = $data['name'];
        $this->email = $data['email'];
        $this->phone = $data['phone'] ??  null;
        $this->maxGuests = $data['max_guests'];
    }

    public static function fromRequest(Request $request): self
    {
        return new self($request->only(['name', 'email', 'phone', 'max_guests']));
    }
}