<?php

namespace App\DTOs\Guest;

class RsvpDto
{
    public string $slug;
    public string $name;
    public ?string $dietary_restrictions;
    public ?string $comments;
    public ?string $attendance;
    public int $guest_count;

    public function __construct(array $data)
    {
        $this->slug = $data['slug'];
        $this->name = $data['name'];
        $this->dietary_restrictions = $data['dietary_restrictions'] ?? null;
        $this->comments = $data['comments'] ?? null;
        $this->attendance = $data['asistencia'] ?? null;
        $this->guest_count = (int) ($data['guest_count'] ?? 0);
    }

    public function confirmed(): bool
    {
        return $this->attendance === 'yes';
    }
}