<?php

namespace App\DTOs\Guest;

use Illuminate\Http\Request;

class UpdateEventDTO
{
    public string $name;
    public string $name_husband;
    public string $name_wife;
    public ?string $description;
    public ?string $whatsapp_contact;

    // Familia
    public ?string $parents;

    // Boda Ceremonial
    public string $ceremony_place;
    public string $location_ceremony;
    public string $location_google_maps_ceremony;
    public string $start_date_only;
    public string $start_time_only;

    // Boda Civil
    public ?string $civil_place;
    public ?string $location_civil;
    public ?string $location_google_maps_civil;
    public ?string $start_date_only_civil;
    public ?string $start_time_only_civil;

    /**
     * @param array $data Los datos validados del request.
     */
    public function __construct(array $data)
    {
        // General
        $this->name = $data['name'];
        $this->name_husband = $data['name_husband'];
        $this->name_wife = $data['name_wife'];
        $this->description = $data['description'] ?? '';
        $this->whatsapp_contact = $data['whatsapp_contact'] ?? '';

        // Familia (opcionales)
        $this->parents = $data['parents'] ?? '';
        
        // Boda Ceremonial (requeridos)
        $this->ceremony_place = $data['ceremony_place'];
        $this->location_ceremony = $data['location_ceremony'];
        $this->location_google_maps_ceremony = $data['location_google_maps_ceremony'];
        $this->start_date_only = $data['start_date_only'];
        $this->start_time_only = $data['start_time_only'];

        // Boda Civil (opcionales)
        $this->civil_place = $data['civil_place'] ?? '';
        $this->location_civil = $data['location_civil'] ?? '';
        $this->location_google_maps_civil = $data['location_google_maps_civil'] ?? '';
        $this->start_date_only_civil = $data['start_date_only_civil'] ?? '';
        $this->start_time_only_civil = $data['start_time_only_civil'] ?? '';
    }

    public static function fromRequest(Request $request): self
    {
        return new self($request->validated());
    }

    /**
     * Convierte el DTO en un array apto para el método update() o create() del modelo.
     */
    public function toArray(): array
    {
        $data = (array) $this;
        // Filtra los valores nulos para no enviar campos con valor null a la BD si son opcionales
        return array_filter($data, function ($value) {
            return !is_null($value);
        });
    }
}