<?php

namespace App\Http\Controllers\Admin;

use App\DTOs\Auth\RegisterDTO;
use App\DTOs\Auth\UpdateUserDTO;
use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\RegisterRequest;
use App\Http\Requests\Auth\UpdateUserRequest;
use App\Services\AuthService;
use App\Services\UserService;

class UserController extends Controller
{
    public function __construct(protected UserService $userService, protected AuthService $authService)
    {
    }

    public function index()
    {
        $users = $this->userService->getUserByRole("organizer");
        return view('users.index', compact('users'));
    }

    public function create()
    {
        return view('users.create');
    }

    public function store(RegisterRequest $request)
    {
        $dto = RegisterDTO::fromRequest($request);
        $userNew = $this->authService->register($dto);
        if (!$userNew) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['general' => 'Ocurrió un error al guardar el usuario. Intenta nuevamente.']);
        }

        return redirect()->route('users.index')->with('success', 'Usuario creado correctamente.');
    }

    public function show($id)
    {
        $user = $this->userService->getUserById($id);
        if (!$user) {
            abort(404);
        }
        return view('users.show', compact('user'));
    }

    public function edit($id){
        $user = $this->userService->getUserById($id);
        if (!$user) {
            abort(404);
        }
        return view('users.edit', compact('user'));
    }

    public function update(UpdateUserRequest $request, $id)
    {
        $dto = UpdateUserDTO::fromRequest($request);

        $user = $this->authService->update($id, $dto);

        if (!$user) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['general' => 'No se pudo actualizar el usuario.']);
        }

        return redirect()->route('users.index')->with('success', 'Usuario actualizado correctamente.');
    }

    public function destroy($id)
    {
        $deleted = $this->userService->delete($id);
        if ($deleted) {
            return redirect()->route('users.index')->with('success', 'Usuario eliminado correctamente.');
        }
        return redirect()->route('users.index')->with('error', 'No se pudo eliminar el usuario.');
    }
}