<?php

namespace App\Http\Controllers\Organizer;

use App\Http\Controllers\Controller;
use App\Services\GuestService;
use App\Services\RsvpService;
use App\Services\TwilioService;
use Illuminate\Http\Request;


class RsvpController extends Controller
{
    public function __construct(protected RsvpService $rsvpService, protected GuestService $guestService, protected TwilioService $twilioService)
    {
    }

    public function index(Request $request)
    {
        $status = $request->get('status', 'confirmed');
        $rsvps = match ($status) {
            'confirmed' => $this->rsvpService->getPaginated(),
            'not_confirmed' => $this->guestService->getNotConfirmedPaginated(15),
            default => $this->rsvpService->getPaginated(),
        };
        return view('organizer.rsvps.index', compact('rsvps', 'status'));
    }

    public function sendReminder(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'phone' => 'required|string',
            'slug' => 'required|string',
            'channel' => 'required|in:sms,whatsapp',
        ]);

        $message = "Hola {$request->name}, te recordamos confirmar tu asistencia al evento.";

        $success = match ($request->channel) {
            'sms' => $this->twilioService->sendSms($request->phone, $message),
            'whatsapp' => $this->twilioService->sendWhatsapp($request->phone, $request->name, $request->slug),
        };

        return redirect()->back()->with($success ? 'success' : 'error', $success
            ? 'Recordatorio enviado correctamente.'
            : 'Error al enviar el recordatorio.');
    }
}
