<?php

namespace App\Http\Requests\Organizer;

use Illuminate\Foundation\Http\FormRequest;

class SendNotificationsRequest extends FormRequest
{
     public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'guest_ids'   => ['required', 'array', 'min:1'],
            'guest_ids.*' => ['integer', 'exists:guests,id'],
            'action_type' => ['required', 'string', 'in:email,whatsapp'],
        ];
    }

    public function messages(): array
    {
        return [
            'guest_ids.required' => 'Debes seleccionar al menos un invitado.',
            'guest_ids.array'    => 'El formato de los invitados es inválido.',
            'guest_ids.min'      => 'Selecciona al menos un invitado.',
            'guest_ids.*.exists' => 'Uno o más invitados no existen en el sistema.',
            'action_type.required' => 'El tipo de acción es obligatorio.',
            'action_type.in'       => 'El tipo de acción debe ser correo o WhatsApp.',
        ];
    }
}
