<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('name_husband');
            $table->string('name_wife');
            $table->text('description')->nullable();
            $table->string('whatsapp_contact', 20)->nullable();

            $table->string('name_mother_husband')->nullable();
            $table->string('name_mother_wife')->nullable();

            $table->string('ceremony_place');
            $table->text('location_ceremony');
            $table->text('location_google_maps_ceremony');

            $table->date('start_date_only');
            $table->time('start_time_only');

            $table->string('civil_place')->nullable();
            $table->text('location_civil')->nullable();
            $table->text('location_google_maps_civil')->nullable();

            $table->date('start_date_only_civil')->nullable();
            $table->time('start_time_only_civil')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('events');
    }
};