<div class="flex flex-col">
    <div class="flex gap-4 bg-white px-4 py-3 justify-between border-b border-gray-200">
        <div class="flex items-start">
            <div class="flex flex-1 flex-col justify-center">
                <p class="text-[#121216] text-base font-medium leading-normal">{{ $name }}</p>
                <p class="text-[#6a6a81] text-sm font-normal leading-normal">{{ $phone }}</p>
                <p class="text-[#6a6a81] text-sm font-normal leading-normal">{{ $email }}</p>
            </div>
        </div>
        <div class="shrink-0">
            @if(!empty($phone) && $phone !== '(sin teléfono)')
                <form method="POST" action="{{ route('organizer.rsvps.sendReminder') }}">
                    @csrf
                    <input type="hidden" name="slug" value="{{ $slug }}">
                    <input type="hidden" name="name" value="{{ $name }}">
                    <input type="hidden" name="phone" value="{{ $phone }}">
                    <input type="hidden" name="channel" value="whatsapp">
                    <button
                        type="submit"
                        class="flex min-w-[84px] max-w-[480px] cursor-pointer items-center justify-center overflow-hidden rounded-full h-8 px-4 bg-[#f1f1f4] text-[#121216] text-sm font-medium leading-normal w-fit"
                    >
                        <span class="truncate">{{ $buttonText ?? 'Send Reminder' }}</span>
                    </button>
                </form>
            @else
                <button
                    disabled
                    class="flex min-w-[84px] max-w-[480px] cursor-not-allowed items-center justify-center overflow-hidden rounded-full h-8 px-4 bg-gray-200 text-gray-500 text-sm font-medium leading-normal w-fit"
                >
                    Sin teléfono
                </button>
            @endif
        </div>
    </div>
</div>