@props([
    'name' => '',
    'label' => '',
    'type' => 'date',
    'placeholder' => 'Selecciona fecha',
    'value' => null,
    'variant' => 'primary',
])

@php
    $selected = old($name, $value);

    // Paleta por variante
    $palette = [
        'primary'   => 'input-primary',
        'secondary'   => 'input-secondary',
    ][$variant] ?? '';
@endphp

<label {{ $attributes->merge(['class' => "input-main $palette"]) }}>
    @if ($label)
        <p class="label">{{ $label }}</p>
    @endif
    <input type="{{ $type }}" name="{{ $name }}" value="{{ $selected }}"
        placeholder="{{ $placeholder }}"
        class="form-input" />
    @error($name)
        <span class="text-red-500 text-sm mt-2 block">{{ $message }}</span>
    @enderror
</label>
