@props([
    'label' => '',
    'name' => '',
    'id' => '',
    'value' => '',
    'required' => false,
    'autofocus' => false,
    'disabled' => false,
    'placeholder' => '',
    'variant' => 'primary',
    'autocomplete' => 'new-password',
])

@php
    $palette = [
        'primary' => 'input-primary',
        'secondary' => 'input-secondary',
    ][$variant] ?? '';
@endphp

<label {{ $attributes->merge(['class' => "input-main $palette"]) }}>
    <p class="label">{{ $label }}</p>

    <div x-data="{ show: false }" class="relative">
        <input
            :type="show ? 'text' : 'password'"
            type="password"
            name="{{ $name }}"
            id="{{ $id }}"
            class="form-input pr-10"
            value="{{ old($name, $value) }}"
            placeholder="{{ $placeholder }}"
            autocomplete="{{ $autocomplete }}"
            @if($required) required @endif
            @if($autofocus) autofocus @endif
            @if($disabled) disabled @endif
        />

        <button type="button" class="absolute right-2 top-1/2 -translate-y-1/2 text-gray-500"
            @click="show = !show" tabindex="-1">
            <span x-show="!show">
                <x-icons.eye />
            </span>
            <span x-show="show">
                <x-icons.eye-slash />
            </span>
        </button>
    </div>

    @error($name)
        <span class="text-red-500 text-sm mt-2 block">{{ $message }}</span>
    @enderror
</label>