@props([
    'name_husband' => '',
    'name_wife' => '',
    'name_event' => '',
    'description' => '',
    'start_date' => '',
    'location' => '',
])

@php
    use Illuminate\Support\Carbon;

    $start = $start_date ? Carbon::parse($start_date)->locale('es') : null;
@endphp
@if(session('success'))
<div id="modal-success"
    class="fixed inset-0 z-[999] flex items-center justify-center bg-primary100/40 opacity-0 scale-95">
    <div class="relative bg-white rounded-4xl py-12 md:py-16 shadow-lg max-w-xl w-full">
        <!-- Círculo azul -->
        <div class="absolute -top-12 right-0 md:right-8 w-24 h-24 bg-primary200 rounded-full z-0"></div>

        <!-- Contenido -->
        <div class="relative z-10">
            <div class="container">
                <h3 class="text-size-subtitle font-main text-black mb-4">¡Gracias por confirmar tu asistencia!</h3>
                @if ($start)
                <h4 class="font-secondary parrafo font-medium text-complement400 mb-4">
                    Tu pase de abordar está listo y te esperamos con emoción en la puerta de embarque:
                    {{ ucfirst($start->translatedFormat('j \d\e F')) }}, {{ $location }}. Prepara tus maletas (y tus mejores pasos de baile). Nos vemos muy
                    pronto. 💛
                </h4>
                @endif
                <h2 class="font-secondary text-size-heading font-medium text-complement400">— {{ $name_wife }} & {{ $name_husband }}</h2>
                <h4 class="font-secondary parrafo text-complement200 font-medium mt-4">Agrega este evento en tu calendario y recibe un recordatorio automático.</h4>
                <div class="mt-4 md:mt-6">
                    <div class="flex flex-wrap gap-4">
                       <x-controls.calendar-button
                            icon="calendar"
                            label="Google Calendar"
                            :title="$name_event"
                            :description="$description"
                            location="Queretaro"
                            :start-date="$start_date"
                            typeCalendar="google"
                        />
                        <x-controls.calendar-button
                            icon="outlook"
                            label="Outlook Calendar"
                            :title="$name_event"
                            :description="$description"
                            location="Queretaro"
                            :start-date="$start_date"
                            typeCalendar="outlook"
                        />

                        <x-controls.calendar-button
                            icon="download"
                            label="Descargar .ics"
                            :title="$name_event"
                            :description="$description"
                            location="Queretaro"
                            :start-date="$start_date"
                            typeCalendar="ics"
                        />
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif