<x-layouts.auth-layout>
    <div x-data="{ activeTab: 'evento' }">
        <div class="mb-4 md:mb-8 border-b border-gray-200">
            <ul class="flex flex-wrap -mb-px text-sm font-medium text-center" id="myTab" role="tablist">
                <li class="me-2" role="presentation">
                    <button @click="activeTab = 'evento'"
                        :class="{ 'text-indigo-600 border-indigo-600': activeTab === 'evento', 'text-gray-500 hover:text-gray-600 hover:border-gray-300': activeTab !== 'evento' }"
                        class="inline-block p-4 border-b-2 rounded-t-lg transition-colors duration-200 focus:outline-none"
                        id="evento-tab" type="button" role="tab" aria-controls="evento"
                        :aria-selected="activeTab === 'evento'">
                        General
                    </button>
                </li>
                <li class="me-2" role="presentation">
                    <button @click="activeTab = 'fechas'"
                        :class="{ 'text-indigo-600 border-indigo-600': activeTab === 'fechas', 'text-gray-500 hover:text-gray-600 hover:border-gray-300': activeTab !== 'fechas' }"
                        class="inline-block p-4 border-b-2 rounded-t-lg transition-colors duration-200 focus:outline-none"
                        id="fechas-tab" type="button" role="tab" aria-controls="fechas"
                        :aria-selected="activeTab === 'fechas'">
                        Detalles
                    </button>
                </li>
            </ul>
        </div>
        <form action="{{ route('organizer.event.update') }}" method="POST">
            @csrf
            @method('PUT')
            <div id="myTabContent">
                <div x-show="activeTab === 'evento'" id="evento" role="tabpanel" aria-labelledby="evento-tab">
                    <div class="flex flex-col max-w-[640px]">
                        <h3 class="text-complement300 font-roboto text-size-subtitle mb-4 md:mb-6">Mi evento</h3>
                        <x-alerts.success />
                        <x-alerts.error />
                        <x-controls.error-main />
                        <x-controls.validation-errors />
                        {{-- Nombre del evento --}}
                        <x-controls.input type="text" name="name" placeholder="Escribe el nombre del evento"
                            label="Nombre del evento" value="{{ old('name', $event->name ?? '') }}" required
                            autofocus />
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-x-4">
                            {{-- Nombre del esposo --}}
                            <x-controls.input type="text" name="name_husband" placeholder="Escribe el nombre del esposo"
                                label="Nombre del esposo" value="{{ old('name_husband', $event->name_husband ?? '') }}"
                                required autofocus />
                            {{-- Nombre de la esposa --}}
                            <x-controls.input type="text" name="name_wife" placeholder="Escribe el nombre de la esposa"
                                label="Nombre de la esposa" value="{{ old('name_wife', $event->name_wife ?? '') }}"
                                required autofocus />
                        </div>
                        {{-- Descripción del evento --}}
                        <!-- <x-controls.textarea label="Descripción del evento" name="description"
                            placeholder="Escribe la descripción del evento"
                            value="{{ old('description', $event->description ?? '') }}" /> -->
                        {{-- Contacto de WhatsApp --}}
                        <!-- <x-controls.input type="text" name="whatsapp_contact"
                            placeholder="Escribe tu contacto de WhatsApp" label="Contacto de WhatsApp"
                            value="{{ old('whatsapp_contact', $event->whatsapp_contact ?? '') }}" autofocus /> -->
                        <hr class="my-4 bg-gray-400 border-0 h-[1px]" />
                        <div class="flex flex-col">
                            <h3 class="text-complement300 font-roboto text-size-heading mb-4 md:mb-6">Familia
                            </h3>
                            {{-- Padres --}}
                            <x-controls.textarea label="Padres de familia" name="parents"
                                placeholder="Escribe los nombres de los padres o madres"
                                value="{{ old('parents', $event->parents ?? '') }}" />
                        </div>
                    </div>
                </div>
                <div x-show="activeTab === 'fechas'" id="fechas" role="tabpanel" aria-labelledby="fechas-tab"
                    style="display: none;">
                    <div class="flex flex-col max-w-[640px]">
                        <div class="flex flex-col">
                            <h3 class="text-complement300 font-roboto text-size-subtitle mb-4 md:mb-6">Boda Ceremonial
                            </h3>
                            {{-- Lugar del evento ceremonial --}}
                            <x-controls.input type="text" name="ceremony_place"
                                placeholder="Escribe el lugar del evento" label="Lugar del evento"
                                value="{{ old('ceremony_place', $event->ceremony_place ?? '') }}" required autofocus />
                            {{-- Ubicación del evento ceremonial --}}
                            <x-controls.textarea label="Ubicación" name="location_ceremony"
                                placeholder="Escribe la ubicación del evento"
                                value="{{ old('location_ceremony', $event->location_ceremony ?? '') }}" />
                            {{-- Ubicación google maps ceremonial --}}
                            <x-controls.input type="text" name="location_google_maps_ceremony"
                                placeholder="Introduce la url del google maps" label="Ubicación google maps"
                                value="{{ old('location_google_maps_ceremony', $event->location_google_maps_ceremony ?? '') }}"
                                required autofocus />
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-4">
                                {{-- Fecha ceremonial --}}
                                <x-controls.date-input name="start_date_only" type="date" class="only-date"
                                    placeholder="Introduce la fecha" label="Fecha"
                                    value="{{ old('start_date_only', $event?->start_date_only?->format('Y-m-d')) }}" />
                                {{-- Hora ceremonial --}}
                                <x-controls.date-input name="start_time_only" type="time" class="only-time"
                                    placeholder="Introduce la Hora" label="Hora"
                                    value="{{ old('start_time_only', $event?->start_time_only) }}" />
                            </div>
                        </div>
                        <hr class="my-4 bg-gray-400 border-0 h-[1px]" />
                        <div class="flex flex-col">
                            <h3 class="text-complement300 font-roboto text-size-subtitle mb-4 md:mb-6">Boda Civil
                            </h3>
                            {{-- Lugar del evento civil --}}
                            <x-controls.input type="text" name="civil_place" placeholder="Escribe el lugar del evento"
                                label="Lugar del evento" value="{{ old('civil_place', $event->civil_place ?? '') }}"
                                required autofocus />
                            {{-- Ubicación del evento civil --}}
                            <x-controls.textarea label="Ubicación" name="location_civil"
                                placeholder="Escribe la ubicación del evento"
                                value="{{ old('location_civil', $event->location_civil ?? '') }}" />
                            {{-- Ubicación google maps civil --}}
                            <x-controls.input type="text" name="location_google_maps_civil"
                                placeholder="Introduce la url del google maps" label="Ubicación google maps"
                                value="{{ old('location_google_maps_civil', $event->location_google_maps_civil ?? '') }}"
                                required autofocus />
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-4">
                                {{-- Fecha civil --}}
                                <x-controls.date-input name="start_date_only_civil" type="date" class="only-date"
                                    placeholder="Introduce la fecha" label="Fecha"
                                    value="{{ old('start_date_only_civil', $event?->start_date_only_civil?->format('Y-m-d')) }}" />
                                {{-- Hora civil --}}
                                <x-controls.date-input name="start_time_only_civil" type="time" class="only-time"
                                    placeholder="Introduce la Hora" label="Hora"
                                    value="{{ old('start_time_only_civil', $event?->start_time_only_civil) }}" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {{-- Botones --}}
            <div class="flex gap-4 mt-8">
                <x-controls.button type="submit">Guardar</x-controls.button>
            </div>
        </form>
    </div>
</x-layouts.auth-layout>