<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <title><?php echo e(config('app.name', 'Webodorrio')); ?></title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <link rel="icon" href="<?php echo e(asset('favicon.ico')); ?>" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">
    <!-- <?php
        $manifest = json_decode(file_get_contents(public_path('build/manifest.json')), true);
    ?>
    <link rel="stylesheet" href="<?php echo e(asset('build/' . $manifest['resources/css/app.css']['file'])); ?>">
    <script type="module" src="<?php echo e(asset('build/' . $manifest['resources/js/app.js']['file'])); ?>"></script> -->
</head>

<body class="overflow-x-hidden">
    <div class="min-h-screen">
        <main>
            <?php echo e($slot); ?>

        </main>
    </div>
    <!-- Alpine Plugins -->
    <script defer src="https://cdn.jsdelivr.net/npm/@alpinejs/collapse@3.x.x/dist/cdn.min.js"></script>
    <!-- Alpine Core -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</body>

</html><?php /**PATH C:\laragon\webodorrio\resources\views/components/layouts/simple-auth-layout.blade.php ENDPATH**/ ?>