<div class="flex flex-col">
    <div class="flex gap-4 bg-white px-4 py-3 justify-between border-b border-gray-200">
        <div class="flex items-start">
            <div class="flex flex-1 flex-col justify-center">
                <p class="text-[#121216] text-base font-medium leading-normal"><?php echo e($name); ?></p>
                <p class="text-[#6a6a81] text-sm font-normal leading-normal"><?php echo e($phone); ?></p>
                <p class="text-[#6a6a81] text-sm font-normal leading-normal"><?php echo e($email); ?></p>
            </div>
        </div>
        <div class="shrink-0">
            <?php if(!empty($phone) && $phone !== '(sin teléfono)'): ?>
                <form method="POST" action="<?php echo e(route('organizer.rsvps.sendReminder')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="slug" value="<?php echo e($slug); ?>">
                    <input type="hidden" name="name" value="<?php echo e($name); ?>">
                    <input type="hidden" name="phone" value="<?php echo e($phone); ?>">
                    <input type="hidden" name="channel" value="whatsapp">
                    <button
                        type="submit"
                        class="flex min-w-[84px] max-w-[480px] cursor-pointer items-center justify-center overflow-hidden rounded-full h-8 px-4 bg-[#f1f1f4] text-[#121216] text-sm font-medium leading-normal w-fit"
                    >
                        <span class="truncate"><?php echo e($buttonText ?? 'Send Reminder'); ?></span>
                    </button>
                </form>
            <?php else: ?>
                <button
                    disabled
                    class="flex min-w-[84px] max-w-[480px] cursor-not-allowed items-center justify-center overflow-hidden rounded-full h-8 px-4 bg-gray-200 text-gray-500 text-sm font-medium leading-normal w-fit"
                >
                    Sin teléfono
                </button>
            <?php endif; ?>
        </div>
    </div>
</div><?php /**PATH C:\laragon\webodorrio\resources\views/components/cards/contact-card.blade.php ENDPATH**/ ?>