<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'tabs' => [],
    'activeTab' => null,
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'tabs' => [],
    'activeTab' => null,
]); ?>
<?php foreach (array_filter(([
    'tabs' => [],
    'activeTab' => null,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div <?php echo e($attributes->merge(['class' => 'flex border-b border-[#dbe0e6] px-4 gap-8'])); ?>>
    <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a
            href="javascript:void(0);"
            class="tab-button flex flex-col items-center justify-center border-b-[3px] pb-[13px] pt-4 transition-colors duration-200"
            data-tab="<?php echo e($tab['id']); ?>"
        >
            <p class="text-sm font-bold leading-normal tracking-[0.015em]">
                <?php echo e($tab['label']); ?>

            </p>
        </a>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const tabs = document.querySelectorAll('.tab-button');
        const activeId = <?php echo json_encode($activeTab, 15, 512) ?>;

        function activateTab(id) {
            tabs.forEach(tab => {
                const isActive = tab.dataset.tab === id;
                tab.classList.toggle('border-b-[#111418]', isActive);
                tab.classList.toggle('text-[#111418]', isActive);
                tab.classList.toggle('border-b-transparent', !isActive);
                tab.classList.toggle('text-[#60758a]', !isActive);
            });

            // Mostrar/ocultar contenido
            document.querySelectorAll('[data-tab-content]').forEach(content => {
                content.style.display = content.dataset.tabContent === id ? 'block' : 'none';
            });
        }

        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                const tabId = tab.dataset.tab;
                activateTab(tabId);
            });
        });

        if (activeId) {
            activateTab(activeId);
        }
    });
</script><?php /**PATH C:\laragon\webodorrio\resources\views/components/tabs/tabs-navigation.blade.php ENDPATH**/ ?>