<?php
    $menuItems = [
        'admin' => [
            ['route' => 'admin.dashboard', 'icon' => 'house', 'label' => 'Panel'],
            ['route' => 'users.index', 'icon' => 'user', 'label' => 'Usuarios'],
        ],
        'organizer' => [
            ['route' => 'admin.dashboard', 'icon' => 'house', 'label' => 'Panel'],
            ['route' => 'organizer.event.edit', 'icon' => 'document', 'label' => 'Datos generales'],
            ['route' => 'organizer.guests.index', 'icon' => 'people', 'label' => 'Invitados'],
            ['route' => 'organizer.notifications.index', 'icon' => 'chat', 'label' => 'Notificaciones'],
            ['route' => 'organizer.rsvps.index', 'icon' => 'document-check', 'label' => 'Confirmación de Asistencia'],
        ],
    ];
?>
<div x-data="{ openSidebar: false }">
    <!-- BACKDROP (solo en mobile) -->
    <div x-show="openSidebar" @click="openSidebar = false" class="fixed inset-0 z-40 bg-black/50 lg:hidden"
        x-transition.opacity></div>

    <!-- SIDEBAR -->
    <div :class="{ 'translate-x-0': openSidebar, '-translate-x-full': !openSidebar }"
        class="fixed top-0 left-0 z-[200] h-screen w-[240px] border-r border-r-gray-400 bg-white transform transition-transform duration-300 ease-in-out lg:translate-x-0">
        <div class="flex flex-col h-full p-4 justify-between min-h-[700px]">
            <div class="flex flex-col gap-4">
                <a href="/">
                    <h1 class="text-black text-size-subtitle font-roboto font-medium"><?php echo e(config('app.name', 'Tamira')); ?></h1>
                </a>
                <!-- Menú -->
                <?php if(auth()->check()): ?>
                    <?php $__currentLoopData = auth()->user()->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(isset($menuItems[$role->name])): ?>
                            <?php $__currentLoopData = $menuItems[$role->name]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if (isset($component)) { $__componentOriginal5335e6a8fe017583baf62f034ee7c13c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5335e6a8fe017583baf62f034ee7c13c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.nav.link','data' => ['route' => $item['route'],'icon' => $item['icon']]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('nav.link'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['route' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($item['route']),'icon' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($item['icon'])]); ?><?php echo e($item['label']); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5335e6a8fe017583baf62f034ee7c13c)): ?>
<?php $attributes = $__attributesOriginal5335e6a8fe017583baf62f034ee7c13c; ?>
<?php unset($__attributesOriginal5335e6a8fe017583baf62f034ee7c13c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5335e6a8fe017583baf62f034ee7c13c)): ?>
<?php $component = $__componentOriginal5335e6a8fe017583baf62f034ee7c13c; ?>
<?php unset($__componentOriginal5335e6a8fe017583baf62f034ee7c13c); ?>
<?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php if (isset($component)) { $__componentOriginal5335e6a8fe017583baf62f034ee7c13c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5335e6a8fe017583baf62f034ee7c13c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.nav.link','data' => ['onclick' => 'event.preventDefault();
                                        this.closest(\'form\').submit();','route' => 'logout','icon' => 'logout']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('nav.link'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['onclick' => 'event.preventDefault();
                                        this.closest(\'form\').submit();','route' => 'logout','icon' => 'logout']); ?>Cerrar
                        sesión <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5335e6a8fe017583baf62f034ee7c13c)): ?>
<?php $attributes = $__attributesOriginal5335e6a8fe017583baf62f034ee7c13c; ?>
<?php unset($__attributesOriginal5335e6a8fe017583baf62f034ee7c13c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5335e6a8fe017583baf62f034ee7c13c)): ?>
<?php $component = $__componentOriginal5335e6a8fe017583baf62f034ee7c13c; ?>
<?php unset($__componentOriginal5335e6a8fe017583baf62f034ee7c13c); ?>
<?php endif; ?>
                </form>
            </div>
        </div>
    </div>

    <!-- NAVBAR -->
    <nav class="fixed top-0 left-0 z-50 bg-gray-300 w-full lg:hidden">
        <div class="container">
            <div class="flex justify-between items-center h-[80px]">
                <a href="/" class="text-[#111418] text-base font-medium">
                    <?php echo e(config('app.name', 'Tamira')); ?>

                </a>

                <!-- BOTÓN HAMBURGUESA SOLO EN MOBILE -->
                <button type="button" class="h-11 w-11 flex justify-center items-center lg:hidden"
                    @click="openSidebar = true">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 9h16.5m-16.5 6.75h16.5" />
                    </svg>
                </button>
            </div>
        </div>
    </nav>
</div><?php /**PATH C:\laragon\webodorrio\resources\views/components/menu/sidebar.blade.php ENDPATH**/ ?>