<section class="pt-24 md:pt-48 pb-16 bg-gradient-purple">
    <div class="container">
        <div class="flex flex-col mb-8 lg:hidden">
            <h3 class="text-size-title text-accent font-main mb-4 text-animated-opacity-split">Código de vestimenta</h3>
            <h2 class="text-size-main text-main font-main mb-6 md:mb-8 text-animated-opacity-split">Formal</h2>
        </div>
        <div class="flex flex-col lg:flex-row">
            <div class="lg:w-[40%]">
                <img src="<?php echo e(asset('images/assets-travel/shoes.png')); ?>" style="transform: rotate(-5deg);" class="max-w-full" alt="img logo footer">
            </div>
            <div class="w-[60%]">
                <div class="flex-col mb-8 hidden lg:flex">
                    <h3 class="text-size-title text-accent font-main mb-4 text-animated-opacity-split">Código de
                        vestimenta</h3>
                    <h2 class="text-size-main text-main font-main mb-6 md:mb-8 text-animated-opacity-split">Formal</h2>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-8">
                    <div class="flex flex-col">
                        <h2 class="text-size-title text-main font-main mb-4 text-animated-opacity-split">Hombres</h2>
                        <h3 class="text-size-heading text-accent font-main text-animated-opacity-split">Traje completo
                            con corbata (sin tenis)</h3>
                    </div>
                    <div class="flex flex-col">
                        <h2 class="text-size-title text-main font-main mb-4 text-animated-opacity-split">Mujeres</h2>
                        <ul class="text-size-heading text-accent font-main">
                            <li class="text-animated-opacity-split">Vestido largo</li>
                            <li class="text-animated-opacity-split">Prohibido blanco, perla, marfil o cualquier tono
                                similar.</li>
                            <li class="text-animated-opacity-split">No lentejuelas ni fluorescentes.</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="lg:flex lg:justify-end mt-8 md:mt-10 lg:mt-14">
            <div class="lg:w-[60%]">
                <div class="flex flex-col">
                    <p class="font-main text-accent text-parrafo parrafo mb-4 text-animated-opacity-split max-w-lg">Para participar en la
                        foto panorámica acude con la siguiente gama de colores:</p>
                    <div x-data="{ isOpen: false }" class="w-full">
                        <div @click="isOpen = !isOpen" class="relative pr-10 mb-4 max-w-[340px]">
                            <h3 class="text-main font-main text-size-subtitle">Ver paleta de color</h3>
                            <span class="absolute top-1/2 -translate-y-1/2 right-0 text-main" :class="{'rotate-180': isOpen}">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                    stroke="currentColor" class="size-6">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
                                </svg>
                            </span>
                        </div>
                        <div class="flex flex-wrap gap-4 max-w-[340px]" x-show="isOpen" x-collapse.duration.500ms>
                            <div class="bg-[#A866BE] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#741476] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#A2008D] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#CD4190] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#ED0C76] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#F36B6D] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#8C89A4] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#9EB990] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#334F29] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#27777E] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#427A9D] w-[40px] aspect-square rounded-[8px]">
                            </div>
                            <div class="bg-[#72B9BF] w-[40px] aspect-square rounded-[8px]">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section><?php /**PATH C:\laragon\webodorrio\resources\views/components/templates/template-travel/block-code-outfit.blade.php ENDPATH**/ ?>