<?php

namespace App\DTOs\Stripe;

class ProductWithPriceDTO
{
    public string $productName;
    public ?string $description;
    public array $prices;
    public array $features;
    public int $maxMenus;
    public int $maxProducts;
    public bool $isActive = true;

    public function __construct(
        string $productName,
        ?string $description,
        array $prices,
        array $features = [],
        int $maxMenus = 0,
        int $maxProducts = 0,
        bool $isActive = true
    ) {
        $this->productName = $productName;
        $this->description = $description;
        $this->prices = $prices;
        $this->features = $features;
        $this->maxMenus = $maxMenus;
        $this->maxProducts = $maxProducts;
        $this->isActive = $isActive;
    }

    public static function fromRequest(\Illuminate\Http\Request $request): self
    {
        return new self(
            $request->input('product_name'),
            $request->input('description'),
            $request->input('prices'),
            $request->input('features', []),
            $request->input('max_menus', 0),
            $request->input('max_products', 0),
            $request->input('is_active', true)
        );
    }
}
