<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Storage;

class FileHelper
{
    /**
     * Sube un archivo a una carpeta del disco `public` y retorna la URL pública.
     */
    public static function upload(?object $file, string $folder): ?string
    {
        if (!$file) return null;

        $fileName = uniqid() . '.' . $file->getClientOriginalExtension();
        $path = $file->storeAs("public/{$folder}", $fileName);
        return Storage::url($path);
    }

    /**
     * Elimina un archivo a partir de su URL pública.
     */
    public static function delete(?string $url): void
    {
        if (!$url) return;

        $storagePath = str_replace(url('storage') . '/', '', $url);
        if (Storage::disk('public')->exists($storagePath)) {
            Storage::disk('public')->delete($storagePath);
        }
    }

    /**
     * Reemplaza un archivo anterior con uno nuevo.
     */
    public static function replace(?object $newFile, ?string $oldUrl, string $folder): ?string
    {
        // Eliminar el archivo anterior si existe
        if ($oldUrl) {
            self::delete($oldUrl);
        }
        // Subir el nuevo archivo
        return self::upload($newFile, $folder);
    }
}