<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Mail\VerifyEmail;
use Illuminate\Http\Response;
use Exception;

class EmailVerificationController extends Controller
{
    public function verify($id, $token)
    {
        $user = User::find($id);
        if (!$user || $user->email_verification_token !== $token) {
            $email = $user->email ?? "";
            return redirect(config('app.frontend_url') . '/auth/email-verification-failed?email=' . urlencode($email));
        }
        $user->email_verified_at = now();
        $user->email_verification_token = null;
        $user->save();

        return redirect(config('app.frontend_url') . '/auth/email-verified');
    }

    public function resend(Request $request)
    {
        $validatedData = Validator::make($request->all(), [
            'email' => 'required|email|exists:users,email',
        ]);
        if ($validatedData->fails()) {
            return response()->json(['error' => $validatedData->errors()->toArray()], 400);
        }
        try {
            $user = User::where('email', $request->email)->first();
            if (!$user) {
                return response()->json(['error' => "Lo sentimos no hemos podido procesar la solicitud."], 500);
            }
            if ($user->email_verified_at) {
                return response()->json(['error' => "Este correo ya fue verificado."], 500);
            }
            $token = bin2hex(random_bytes(64));
            $user->email_verification_token = $token;
            $user->save();
            $url = url('/api/email/verify/' . $user->id . '/' . $token);
            Mail::to($user->email)->send(new VerifyEmail($user, $url));

            return response()->json([
                'message' => "Se ha reenviado el correo de verificación.",
            ], Response::HTTP_OK);
        } catch (Exception $ex) {
            return response()->json(['error' => "Error al crear el usuario"], 500);
        }
    }
}
