<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateProductWithPriceRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'product_name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'prices' => 'required|array|min:1',
            'prices.*.amount' => 'required|numeric|min:1|max:100000',
            'prices.*.currency' => 'required|string|size:3',
            'prices.*.interval' => 'required|string|in:day,week,month,year',
            'prices.*.order' => 'nullable|integer',
            'features' => 'nullable|array',
            'features.*.nameFeature' => 'required|string|max:255',
            'features.*.enabled' => 'required|boolean',
            'max_menus' => 'nullable|integer|min:0',
            'max_products' => 'nullable|integer|min:0',
            'is_active' => 'required|boolean',
        ];
    }

    public function messages(): array
    {
        return [
            'product_name.required' => 'El nombre del plan es obligatorio.',
            'prices.required' => 'Debe incluir al menos un precio.',
            'prices.*.amount.required' => 'El monto del precio es obligatorio.',
            'prices.*.interval.in' => 'El intervalo debe ser válido: day, week, month, year.',
        ];
    }
}
